untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVSeWGEnPiyncdW2NqEObVIsE4FmBWUOjQqdmlPhBhZSzqloVlLmg2IBRmza1qKbkZl4W/nhlVBCiVNrNYLIX2As=

OpenBSD 7.7 errata 002, May 10, 2025:

Fix sign of UTC offset in some timezone files created by zic(8).

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 002_zic.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install zic
    cd /usr/src/usr.sbin/zic
    make obj
    make
    make install

Index: usr.sbin/zic/zic.c
===================================================================
RCS file: /cvs/src/usr.sbin/zic/zic.c,v
diff -u -p -u -r1.27 zic.c
--- usr.sbin/zic/zic.c	18 Sep 2024 17:05:50 -0000	1.27
+++ usr.sbin/zic/zic.c	8 May 2025 23:35:07 -0000
@@ -109,7 +109,7 @@ static void	convert(long val, char *buf)
 static void	convert64(zic_t val, char *buf);
 static void	dolink(const char *fromfield, const char *tofield);
 static void	doabbr(char *abbr, size_t size, struct zone const *zp,
-	    const char *letters, int isdst, int doquotes);
+	    const char *letters, zic_t stdoff, int doquotes);
 static void	eat(const char *name, int num);
 static void	eats(const char *name, int num, const char *rname, int rnum);
 static long	eitol(int i);
@@ -1687,7 +1687,7 @@ abbroffset(char *buf, zic_t offset)
 
 static void
 doabbr(char *abbr, size_t size, struct zone const *zp, const char *letters,
-    int isdst, int doquotes)
+    zic_t stdoff, int doquotes)
 {
 	char	*cp, *slashp;
 	size_t	len;
@@ -1697,11 +1697,11 @@ doabbr(char *abbr, size_t size, struct z
 	if (slashp == NULL) {
 		char letterbuf[PERCENT_Z_LEN_BOUND + 1];
 		if (zp->z_format_specifier == 'z')
-			letters = abbroffset(letterbuf, -zp->z_gmtoff);
+			letters = abbroffset(letterbuf, zp->z_gmtoff + stdoff);
 		else if (letters == NULL)
 			letters = "%s";
 		snprintf(abbr, size, format, letters);
-	} else if (isdst) {
+	} else if (stdoff != 0) {
 		strlcpy(abbr, slashp + 1, size);
 	} else {
 		if (slashp - format + 1 < size)
@@ -1875,7 +1875,7 @@ stringzone(char *result, size_t size, co
 	if (stdrp == NULL && (zp->z_nrules != 0 || zp->z_stdoff != 0))
 		return;
 	abbrvar = (stdrp == NULL) ? "" : stdrp->r_abbrvar;
-	doabbr(result, size, zp, abbrvar, FALSE, TRUE);
+	doabbr(result, size, zp, abbrvar, 0, TRUE);
 	ep = end(result, size);
 	if (stringoffset(ep, size - (ep - result), -zp->z_gmtoff) != 0) {
 		result[0] = '\0';
@@ -1884,7 +1884,8 @@ stringzone(char *result, size_t size, co
 	if (dstrp == NULL)
 		return;
 	ep = end(result, size);
-	doabbr(ep, size - (ep - result), zp, dstrp->r_abbrvar, TRUE, TRUE);
+	doabbr(ep, size - (ep - result), zp, dstrp->r_abbrvar, dstrp->r_stdoff,
+	    TRUE);
 	if (dstrp->r_stdoff != SECSPERMIN * MINSPERHOUR) {
 		ep = end(result, size);
 		if (stringoffset(ep, size - (ep - result),
@@ -2011,7 +2012,7 @@ outzone(const struct zone *zpfirst, int 
 		if (zp->z_nrules == 0) {
 			stdoff = zp->z_stdoff;
 			doabbr(startbuf, max_abbr_len + 1, zp, NULL,
-			    stdoff != 0, FALSE);
+			    stdoff, FALSE);
 			type = addtype(oadd(zp->z_gmtoff, stdoff),
 				startbuf, stdoff != 0, startttisstd,
 				startttisgmt);
@@ -2096,7 +2097,7 @@ outzone(const struct zone *zpfirst, int 
 						    max_abbr_len + 1,
 						    zp,
 						    rp->r_abbrvar,
-						    rp->r_stdoff != 0,
+						    rp->r_stdoff,
 						    FALSE);
 						continue;
 					}
@@ -2107,14 +2108,14 @@ outzone(const struct zone *zpfirst, int 
 						    max_abbr_len + 1,
 						    zp,
 						    rp->r_abbrvar,
-						    rp->r_stdoff != 0,
+						    rp->r_stdoff,
 						    FALSE);
 					}
 				}
 				eats(zp->z_filename, zp->z_linenum,
 				    rp->r_filename, rp->r_linenum);
 				doabbr(ab, max_abbr_len + 1, zp,
-				    rp->r_abbrvar, rp->r_stdoff != 0, FALSE);
+				    rp->r_abbrvar, rp->r_stdoff, FALSE);
 				offset = oadd(zp->z_gmtoff, rp->r_stdoff);
 				type = addtype(offset, ab, rp->r_stdoff != 0,
 				    rp->r_todisstd, rp->r_todisgmt);
