untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24MTUXBqUt9QKpJ17sq0ugFvwLDIbWIcDxLa+L7jtcjJ6IXjl39AfUCg8oIou3M5N7ZpwfWjN46ORh4g8gWxUsgI=

OpenBSD 6.6 errata 038, July 31, 2020:

Pixmaps inside the xserver were an info leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 038_dix.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then compile and rebuild the X server
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/dix/pixmap.c
===================================================================
RCS file: /cvs/xenocara/xserver/dix/pixmap.c,v
retrieving revision 1.13
diff -u -p -r1.13 pixmap.c
--- xserver/dix/pixmap.c	27 Jul 2019 07:57:09 -0000	1.13
+++ xserver/dix/pixmap.c	27 Jul 2020 19:46:56 -0000
@@ -116,7 +116,7 @@ AllocatePixmap(ScreenPtr pScreen, int pi
     if (pScreen->totalPixmapSize > ((size_t) - 1) - pixDataSize)
         return NullPixmap;
 
-    pPixmap = malloc(pScreen->totalPixmapSize + pixDataSize);
+    pPixmap = calloc(1, pScreen->totalPixmapSize + pixDataSize);
     if (!pPixmap)
         return NullPixmap;
 
