/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.javaext;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.PrimitiveNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.truffle.TruffleFrame;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectFieldNode;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectReferenceNode;
import org.graalvm.visualvm.heapviewer.truffle.javaext.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TerminalJavaNodes;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;

abstract class TruffleFieldsProvider
extends HeapViewerNode.Provider {
    TruffleFieldsProvider() {
    }

    public HeapViewerNode[] getNodes(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        List<FieldValue> fields = this.getFields(parent, heap);
        return TruffleFieldsProvider.getNodes(fields, parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
    }

    static HeapViewerNode[] getNodes(final List<FieldValue> fields, HeapViewerNode parent, final Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        if (fields == null) {
            return null;
        }
        NodesComputer<Integer> computer = new NodesComputer<Integer>(fields.size(), UIThresholds.MAX_INSTANCE_FIELDS){

            protected boolean sorts(DataType dataType) {
                return !DataType.COUNT.equals(dataType);
            }

            protected HeapViewerNode createNode(Integer index) {
                return TruffleFieldsProvider.createNode((FieldValue)fields.get(index), heap);
            }

            protected ProgressIterator<Integer> objectsIterator(int index, Progress progress) {
                Iterator iterator = 1.integerIterator((int)index, (int)fields.size());
                return new ProgressIterator(iterator, index, false, progress);
            }

            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.TruffleFieldsProvider_MoreNodes(moreNodesCount);
            }

            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.TruffleFieldsProvider_SamplesContainer(objectsCount);
            }

            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.TruffleFieldsProvider_NodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    private static HeapViewerNode createNode(FieldValue field, Heap heap) {
        if (field instanceof ObjectFieldValue) {
            ObjectFieldValue objectField = (ObjectFieldValue)field;
            Instance fieldInstance = objectField.getInstance();
            if (DynamicObject.isDynamicObject(fieldInstance)) {
                DynamicObject dobject = new DynamicObject(fieldInstance);
                return new DynamicObjectFieldNode<DynamicObject>(dobject, dobject.getType(), field);
            }
            return new TerminalJavaNodes.Field(objectField, false);
        }
        return new PrimitiveNode.Field(field);
    }

    protected abstract List<FieldValue> getFields(HeapViewerNode var1, Heap var2);

    public static class InstanceFieldsProvider
    extends TruffleFieldsProvider {
        private boolean includeStaticFields = true;
        private boolean includeInstanceFields = true;

        public String getName() {
            return Bundle.TruffleFieldsProvider_Name();
        }

        public boolean supportsView(Heap heap, String viewID) {
            return viewID.equals("truffle_objects_javaext");
        }

        public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
            if (parent instanceof InstanceNode && !(parent instanceof DynamicObjectReferenceNode)) {
                InstanceNode node = (InstanceNode)parent;
                if (InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)node.getMode())) {
                    return false;
                }
                Instance instance = node.getInstance();
                return DynamicObject.isDynamicObject(instance) || TruffleFrame.isTruffleFrame(instance);
            }
            return false;
        }

        @Override
        protected List<FieldValue> getFields(HeapViewerNode parent, Heap heap) {
            Instance instance = (Instance)HeapViewerNode.getValue((HeapViewerNode)parent, (DataType)DataType.INSTANCE, (Heap)heap);
            if (DynamicObject.isDynamicObject(instance)) {
                DynamicObject dobj = new DynamicObject(instance);
                if (this.includeStaticFields == this.includeInstanceFields) {
                    ArrayList<FieldValue> fields = new ArrayList<FieldValue>(dobj.getFieldValues());
                    fields.addAll(dobj.getStaticFieldValues());
                    return fields;
                }
                if (this.includeInstanceFields) {
                    return dobj.getFieldValues();
                }
                return dobj.getStaticFieldValues();
            }
            if (TruffleFrame.isTruffleFrame(instance)) {
                TruffleFrame tframe = new TruffleFrame(instance);
                return new ArrayList<FieldValue>(tframe.getFieldValues());
            }
            return null;
        }
    }
}

