/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.progress.spi;

import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.netbeans.progress.spi.InternalHandle;

public final class TaskModel {
    private DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private DefaultListModel model = new DefaultListModel();
    private InternalHandle explicit;

    public void addHandle(InternalHandle internalHandle) {
        this.model.addElement(internalHandle);
        if (internalHandle.isUserInitialized() && this.explicit == null) {
            this.selectionModel.setSelectionInterval(this.model.size() - 1, this.model.size() - 1);
        }
    }

    public void removeHandle(InternalHandle internalHandle) {
        if (this.explicit == internalHandle) {
            this.explicit = null;
        }
        int n = this.model.indexOf(internalHandle);
        if (this.selectionModel.getMinSelectionIndex() == n) {
            this.changeSelection(n);
        }
        InternalHandle internalHandle2 = this.getSelectedHandle();
        this.model.removeElement(internalHandle);
        if (internalHandle2 != null) {
            this.selectionModel.setSelectionInterval(this.model.indexOf(internalHandle2), this.model.indexOf(internalHandle2));
        } else {
            this.selectionModel.clearSelection();
        }
    }

    private void changeSelection(int n) {
        InternalHandle internalHandle = null;
        for (int i = 0; i < this.model.size(); ++i) {
            if (n == i) continue;
            InternalHandle internalHandle2 = (InternalHandle)this.model.getElementAt(i);
            if (internalHandle2.isUserInitialized()) {
                internalHandle = internalHandle2;
                continue;
            }
            if (internalHandle != null) continue;
            internalHandle = internalHandle2;
        }
        if (internalHandle != null) {
            this.selectionModel.setSelectionInterval(this.model.indexOf(internalHandle), this.model.indexOf(internalHandle));
        } else {
            this.selectionModel.clearSelection();
        }
    }

    public void explicitlySelect(InternalHandle internalHandle) {
        this.explicit = internalHandle;
        int n = this.model.indexOf(this.explicit);
        if (n == -1) {
            // empty if block
        }
        this.selectionModel.setSelectionInterval(n, n);
    }

    public InternalHandle getExplicitSelection() {
        return this.explicit;
    }

    public int getSize() {
        return this.model.size();
    }

    public InternalHandle[] getHandles() {
        Object[] objectArray = new InternalHandle[this.model.size()];
        this.model.copyInto(objectArray);
        return objectArray;
    }

    public InternalHandle getSelectedHandle() {
        int n = this.selectionModel.getMinSelectionIndex();
        if (n != -1 && n >= 0 && n < this.model.size()) {
            return (InternalHandle)this.model.getElementAt(this.selectionModel.getMinSelectionIndex());
        }
        return null;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionModel.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionModel.removeListSelectionListener(listSelectionListener);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.model.addListDataListener(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.model.removeListDataListener(listDataListener);
    }
}

