/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.DescribeSnapshotAttributeResult;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SnapshotAttribute;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.cmd.SnapshotAttributeBaseCmd;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeSnapshotAttribute
extends SnapshotAttributeBaseCmd {
    private static final String CREATE_VOLUME_PERMISSION_DESC = "Describe create volume permissions granted on the specified SNAPSHOT.";
    private static final String PRODUCT_CODE_DESC = "Describe the product code associated with the specified SNAPSHOT.";
    private static final String[] DESCRIBE_ATTRIBUTE_ARGS = new String[]{"create-volume-permission", "product-code"};

    public DescribeSnapshotAttribute(String[] args) {
        super("ec2dsnapatt", "ec2-describe-snapshot-attribute");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"create-volume-permission");
        OptionBuilder.withDescription((String)CREATE_VOLUME_PERMISSION_DESC);
        result.addOption(OptionBuilder.create((String)"c"));
        result.addOption(DescribeSnapshotAttribute.createOption("p", "product-code", PRODUCT_CODE_DESC));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "SNAPSHOT";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("create-volume-permission");
        this.printOption("product-code");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describe an attribute on a snapshot. The SNAPSHOT parameter is the ID");
        System.out.println("     of the snapshot for which to describe an attribute.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String snapshotId = this.getSnapshotId();
        this.assertAtLeastOneOptionSet(SNAPSHOT_ATTRIBUTE_ARGS);
        this.assertOnlyOneOptionSet(DESCRIBE_ATTRIBUTE_ARGS);
        SnapshotAttribute.SnapshotAttributeType attributeType = this.getSnapshotAttributeType(jec2);
        RequestResultPair result = jec2.describeSnapshotAttribute(snapshotId, attributeType);
        SnapshotAttribute attribute = ((DescribeSnapshotAttributeResult)result.getResponse()).snapshotAttribute;
        if (attribute != null) {
            out.output(System.out, ((DescribeSnapshotAttributeResult)result.getResponse()).snapshotId, attribute);
            out.printRequestId(System.out, (RequestResult)result);
        } else {
            out.output(System.out, (DescribeSnapshotAttributeResult)result.getResponse());
            out.printRequestId(System.out, (RequestResult)result);
        }
        return true;
    }

    public static void main(String[] args) {
        new DescribeSnapshotAttribute(args).invoke();
    }
}

