/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.draw.Liner;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.DoubleStroke;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.util.ResourceBundleUtil;

public class AttributeKeys {
    private static final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
    public static final AttributeKey<Color> CANVAS_FILL_COLOR = new AttributeKey<Color>("canvasFillColor", Color.class, Color.white, true, labels);
    public static final AttributeKey<Double> CANVAS_FILL_OPACITY = new AttributeKey<Double>("canvasFillOpacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<Double> CANVAS_WIDTH = new AttributeKey<Object>("canvasWidth", Double.class, null, true, labels);
    public static final AttributeKey<Double> CANVAS_HEIGHT = new AttributeKey<Object>("canvasHeight", Double.class, null, true, labels);
    public static final AttributeKey<Color> FILL_COLOR = new AttributeKey<Color>("fillColor", Color.class, Color.white, true, labels);
    public static final AttributeKey<Boolean> PATH_CLOSED = new AttributeKey<Boolean>("pathClosed", Boolean.class, false, false, labels);
    public static final AttributeKey<Boolean> UNCLOSED_PATH_FILLED = new AttributeKey<Boolean>("unclosedPathFilled", Boolean.class, false, false, labels);
    public static final AttributeKey<WindingRule> WINDING_RULE = new AttributeKey<WindingRule>("windingRule", WindingRule.class, WindingRule.EVEN_ODD, false, labels);
    public static final AttributeKey<Underfill> FILL_UNDER_STROKE = new AttributeKey<Underfill>("fillUnderStroke", Underfill.class, Underfill.CENTER, false, labels);
    public static final AttributeKey<Color> STROKE_COLOR = new AttributeKey<Color>("strokeColor", Color.class, Color.black, true, labels);
    public static final AttributeKey<Double> STROKE_WIDTH = new AttributeKey<Double>("strokeWidth", Double.class, 1.0, false, labels);
    public static final AttributeKey<Double> STROKE_INNER_WIDTH_FACTOR = new AttributeKey<Double>("innerStrokeWidthFactor", Double.class, 2.0, false, labels);
    public static final AttributeKey<Integer> STROKE_JOIN = new AttributeKey<Integer>("strokeJoin", Integer.class, 0, false, labels);
    public static final AttributeKey<Integer> STROKE_CAP = new AttributeKey<Integer>("strokeCap", Integer.class, 0, false, labels);
    public static final AttributeKey<Double> STROKE_MITER_LIMIT = new AttributeKey<Double>("strokeMiterLimitFactor", Double.class, 3.0, false, labels);
    public static final AttributeKey<Boolean> IS_STROKE_MITER_LIMIT_FACTOR = new AttributeKey<Boolean>("isStrokeMiterLimitFactor", Boolean.class, true, false, labels);
    public static final AttributeKey<double[]> STROKE_DASHES = new AttributeKey<Object>("strokeDashes", double[].class, null, true, labels);
    public static final AttributeKey<Double> STROKE_DASH_PHASE = new AttributeKey<Double>("strokeDashPhase", Double.class, 0.0, false, labels);
    public static final AttributeKey<Boolean> IS_STROKE_DASH_FACTOR = new AttributeKey<Boolean>("isStrokeDashFactor", Boolean.class, true, false, labels);
    public static final AttributeKey<StrokeType> STROKE_TYPE = new AttributeKey<StrokeType>("strokeType", StrokeType.class, StrokeType.BASIC, false, labels);
    public static final AttributeKey<StrokePlacement> STROKE_PLACEMENT = new AttributeKey<StrokePlacement>("strokePlacement", StrokePlacement.class, StrokePlacement.CENTER, false, labels);
    public static final AttributeKey<String> TEXT = new AttributeKey<Object>("text", String.class, null, true, labels);
    public static final AttributeKey<Color> TEXT_COLOR = new AttributeKey<Color>("textColor", Color.class, Color.BLACK, false, labels);
    public static final AttributeKey<Color> TEXT_SHADOW_COLOR = new AttributeKey<Object>("textShadowColor", Color.class, null, true, labels);
    public static final AttributeKey<Dimension2DDouble> TEXT_SHADOW_OFFSET = new AttributeKey<Dimension2DDouble>("textShadowOffset", Dimension2DDouble.class, new Dimension2DDouble(1.0, 1.0), false, labels);
    public static final AttributeKey<Alignment> TEXT_ALIGNMENT = new AttributeKey<Alignment>("textAlignment", Alignment.class, Alignment.LEADING, false, labels);
    public static final AttributeKey<Font> FONT_FACE = new AttributeKey<Font>("fontFace", Font.class, new Font("VERDANA", 0, 10), false, labels);
    public static final AttributeKey<Double> FONT_SIZE = new AttributeKey<Double>("fontSize", Double.class, 12.0, false, labels);
    public static final AttributeKey<Boolean> FONT_BOLD = new AttributeKey<Boolean>("fontBold", Boolean.class, false, false, labels);
    public static final AttributeKey<Boolean> FONT_ITALIC = new AttributeKey<Boolean>("fontItalic", Boolean.class, false, false, labels);
    public static final AttributeKey<Boolean> FONT_UNDERLINE = new AttributeKey<Boolean>("fontUnderline", Boolean.class, false, false, labels);
    public static final AttributeKey<Liner> BEZIER_PATH_LAYOUTER = new AttributeKey<Object>("bezierPathLayouter", Liner.class, null, true, labels);
    public static final AttributeKey<LineDecoration> END_DECORATION = new AttributeKey<Object>("endDecoration", LineDecoration.class, null, true, labels);
    public static final AttributeKey<LineDecoration> START_DECORATION = new AttributeKey<Object>("startDecoration", LineDecoration.class, null, true, labels);
    public static final AttributeKey<Insets2D.Double> DECORATOR_INSETS = new AttributeKey<Insets2D.Double>("decoratorInsets", Insets2D.Double.class, new Insets2D.Double(), false, labels);
    public static final AttributeKey<Insets2D.Double> LAYOUT_INSETS = new AttributeKey<Insets2D.Double>("borderInsets", Insets2D.Double.class, new Insets2D.Double(), false, labels);
    public static final AttributeKey<Alignment> COMPOSITE_ALIGNMENT = new AttributeKey<Alignment>("layoutAlignment", Alignment.class, Alignment.BLOCK, false, labels);
    public static final AttributeKey<Alignment> CHILD_ALIGNMENT = new AttributeKey<Object>("layoutAlignment", Alignment.class, null, true, labels);
    public static final AttributeKey<AffineTransform> TRANSFORM = new AttributeKey<Object>("transform", AffineTransform.class, null, true, labels);
    public static final AttributeKey<Orientation> ORIENTATION = new AttributeKey<Orientation>("orientation", Orientation.class, Orientation.NORTH, false, labels);
    public static final Set<AttributeKey> supportedAttributes;
    public static final Map<String, AttributeKey> supportedAttributeMap;

    public static double getStrokeTotalWidth(Figure figure) {
        switch (figure.get(STROKE_TYPE)) {
            default: {
                return figure.get(STROKE_WIDTH);
            }
            case DOUBLE: 
        }
        return figure.get(STROKE_WIDTH) * (1.0 + figure.get(STROKE_INNER_WIDTH_FACTOR));
    }

    public static double getStrokeTotalMiterLimit(Figure figure) {
        if (figure.get(IS_STROKE_MITER_LIMIT_FACTOR).booleanValue()) {
            return figure.get(STROKE_MITER_LIMIT) * figure.get(STROKE_WIDTH);
        }
        return figure.get(STROKE_MITER_LIMIT);
    }

    public static Stroke getStroke(Figure figure) {
        double d = figure.get(STROKE_WIDTH);
        float f = (float)AttributeKeys.getStrokeTotalMiterLimit(figure);
        double d2 = figure.get(IS_STROKE_DASH_FACTOR) != false ? d : 1.0;
        double d3 = figure.get(STROKE_DASH_PHASE);
        double[] dArray = figure.get(STROKE_DASHES);
        float[] fArray = null;
        boolean bl = true;
        if (dArray != null) {
            fArray = new float[dArray.length];
            double d4 = 0.0;
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = Math.max(0.0f, (float)(dArray[i] * d2));
                d4 += (double)fArray[i];
                if (!bl || fArray[i] == 0.0f) continue;
                bl = false;
            }
            if (fArray.length % 2 == 1) {
                d4 *= 2.0;
            }
            if (d3 < 0.0) {
                d3 = d4 + d3 % d4;
            }
        }
        if (bl) {
            fArray = null;
        }
        switch (figure.get(STROKE_TYPE)) {
            default: {
                return new BasicStroke((float)d, figure.get(STROKE_CAP), figure.get(STROKE_JOIN), f, fArray, Math.max(0.0f, (float)(d3 * d2)));
            }
            case DOUBLE: 
        }
        return new DoubleStroke((float)(figure.get(STROKE_INNER_WIDTH_FACTOR) * d), (float)d, figure.get(STROKE_CAP), figure.get(STROKE_JOIN), f, fArray, Math.max(0.0f, (float)(d3 * d2)));
    }

    public static Stroke getHitStroke(Figure figure) {
        double d = Math.max(1.0, figure.get(STROKE_WIDTH));
        float f = (float)AttributeKeys.getStrokeTotalMiterLimit(figure);
        double d2 = figure.get(IS_STROKE_DASH_FACTOR) != false ? d : 1.0;
        switch (figure.get(STROKE_TYPE)) {
            default: {
                return new BasicStroke((float)d, figure.get(STROKE_CAP), figure.get(STROKE_JOIN), f, null, Math.max(0.0f, (float)(figure.get(STROKE_DASH_PHASE) * d2)));
            }
            case DOUBLE: 
        }
        return new DoubleStroke((float)(figure.get(STROKE_INNER_WIDTH_FACTOR) * d), (float)d, figure.get(STROKE_CAP), figure.get(STROKE_JOIN), f, null, Math.max(0.0f, (float)((double)figure.get(STROKE_DASH_PHASE).floatValue() * d2)));
    }

    public static Font getFont(Figure figure) {
        Font font = figure.get(FONT_FACE);
        if (font == null) {
            return null;
        }
        if (AttributeKeys.getFontStyle(figure) != 0) {
            return font.deriveFont(AttributeKeys.getFontStyle(figure), figure.get(FONT_SIZE).floatValue());
        }
        return font.deriveFont(figure.get(FONT_SIZE).floatValue());
    }

    public static int getFontStyle(Figure figure) {
        int n = 0;
        if (figure.get(FONT_BOLD).booleanValue()) {
            n |= 1;
        }
        if (figure.get(FONT_ITALIC).booleanValue()) {
            n |= 2;
        }
        return n;
    }

    public static double getPerpendicularFillGrowth(Figure figure) {
        double d;
        double d2 = AttributeKeys.getStrokeTotalWidth(figure);
        StrokePlacement strokePlacement = figure.get(STROKE_PLACEMENT);
        block0 : switch (figure.get(FILL_UNDER_STROKE)) {
            case FULL: {
                switch (strokePlacement) {
                    case INSIDE: {
                        d = 0.0;
                        break block0;
                    }
                    case OUTSIDE: {
                        d = d2;
                        break block0;
                    }
                }
                d = d2 / 2.0;
                break;
            }
            case NONE: {
                switch (strokePlacement) {
                    case INSIDE: {
                        d = -d2;
                        break block0;
                    }
                    case OUTSIDE: {
                        d = 0.0;
                        break block0;
                    }
                }
                d = d2 / -2.0;
                break;
            }
            default: {
                switch (strokePlacement) {
                    case INSIDE: {
                        d = d2 / -2.0;
                        break block0;
                    }
                    case OUTSIDE: {
                        d = d2 / 2.0;
                        break block0;
                    }
                }
                d = 0.0;
            }
        }
        return d;
    }

    public static double getPerpendicularDrawGrowth(Figure figure) {
        double d;
        double d2 = AttributeKeys.getStrokeTotalWidth(figure);
        switch (figure.get(STROKE_PLACEMENT)) {
            case INSIDE: {
                d = d2 / -2.0;
                break;
            }
            case OUTSIDE: {
                d = d2 / 2.0;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    public static double getPerpendicularHitGrowth(Figure figure) {
        double d;
        if (figure.get(STROKE_COLOR) == null) {
            d = AttributeKeys.getPerpendicularFillGrowth(figure);
        } else {
            double d2 = AttributeKeys.getStrokeTotalWidth(figure);
            d = AttributeKeys.getPerpendicularDrawGrowth(figure) + d2 / 2.0;
        }
        return d;
    }

    static {
        HashSet<AttributeKey> hashSet = new HashSet<AttributeKey>();
        hashSet.addAll(Arrays.asList(FILL_COLOR, FILL_UNDER_STROKE, STROKE_COLOR, STROKE_WIDTH, STROKE_INNER_WIDTH_FACTOR, STROKE_JOIN, STROKE_CAP, STROKE_MITER_LIMIT, STROKE_DASHES, STROKE_DASH_PHASE, STROKE_TYPE, STROKE_PLACEMENT, TEXT, TEXT_COLOR, TEXT_SHADOW_COLOR, TEXT_SHADOW_OFFSET, TRANSFORM, FONT_FACE, FONT_SIZE, FONT_BOLD, FONT_ITALIC, FONT_UNDERLINE, BEZIER_PATH_LAYOUTER, END_DECORATION, START_DECORATION, DECORATOR_INSETS, ORIENTATION, WINDING_RULE));
        supportedAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeKey> hashMap = new HashMap<String, AttributeKey>();
        for (AttributeKey attributeKey : hashSet) {
            hashMap.put(attributeKey.getKey(), attributeKey);
        }
        supportedAttributeMap = Collections.unmodifiableMap(hashMap);
    }

    public static enum Alignment {
        LEADING,
        TRAILING,
        CENTER,
        BLOCK;

    }

    public static enum Orientation {
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        WEST,
        NORTH_WEST;

    }

    public static enum StrokePlacement {
        CENTER,
        INSIDE,
        OUTSIDE;

    }

    public static enum StrokeType {
        BASIC,
        DOUBLE;

    }

    public static enum Underfill {
        NONE,
        CENTER,
        FULL;

    }

    public static enum WindingRule {
        EVEN_ODD,
        NON_ZERO;

    }
}

