/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Delegator
implements Function {
    protected Scriptable obj = null;

    public Delegator() {
    }

    public Delegator(Scriptable scriptable) {
        this.obj = scriptable;
    }

    protected Delegator newInstance() {
        try {
            return (Delegator)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    public Scriptable getDelegee() {
        return this.obj;
    }

    public void setDelegee(Scriptable scriptable) {
        this.obj = scriptable;
    }

    @Override
    public String getClassName() {
        return this.obj.getClassName();
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        return this.obj.get(string, scriptable);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        return this.obj.get(n, scriptable);
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return this.obj.has(string, scriptable);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return this.obj.has(n, scriptable);
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        this.obj.put(string, scriptable, object);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        this.obj.put(n, scriptable, object);
    }

    @Override
    public void delete(String string) {
        this.obj.delete(string);
    }

    @Override
    public void delete(int n) {
        this.obj.delete(n);
    }

    @Override
    public Scriptable getPrototype() {
        return this.obj.getPrototype();
    }

    @Override
    public void setPrototype(Scriptable scriptable) {
        this.obj.setPrototype(scriptable);
    }

    @Override
    public Scriptable getParentScope() {
        return this.obj.getParentScope();
    }

    @Override
    public void setParentScope(Scriptable scriptable) {
        this.obj.setParentScope(scriptable);
    }

    @Override
    public Object[] getIds() {
        return this.obj.getIds();
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return clazz == null || clazz == ScriptRuntime.ScriptableClass || clazz == ScriptRuntime.FunctionClass ? this : this.obj.getDefaultValue(clazz);
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        return this.obj.hasInstance(scriptable);
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return ((Function)this.obj).call(context, scriptable, scriptable2, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        if (this.obj == null) {
            Delegator delegator = this.newInstance();
            Scriptable scriptable2 = objectArray.length == 0 ? new NativeObject() : ScriptRuntime.toObject(context, scriptable, objectArray[0]);
            delegator.setDelegee(scriptable2);
            return delegator;
        }
        return ((Function)this.obj).construct(context, scriptable, objectArray);
    }
}

