/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.forward.MqttClient;
import org.traccar.forward.PositionData;
import org.traccar.forward.PositionForwarder;
import org.traccar.forward.ResultHandler;

public class PositionForwarderMqtt
implements PositionForwarder {
    private final MqttClient mqttClient;
    private final ObjectMapper objectMapper;
    private final String topic;

    public PositionForwarderMqtt(Config config, ObjectMapper objectMapper) {
        this.topic = config.getString(Keys.FORWARD_TOPIC);
        this.mqttClient = new MqttClient(config.getString(Keys.FORWARD_URL));
        this.objectMapper = objectMapper;
    }

    @Override
    public void forward(PositionData positionData, ResultHandler resultHandler) {
        try {
            String payload = this.objectMapper.writeValueAsString((Object)positionData);
            this.mqttClient.publish(this.topic, payload, (message, e) -> resultHandler.onResult(e == null, (Throwable)e));
        }
        catch (JsonProcessingException e2) {
            resultHandler.onResult(false, e2);
        }
    }
}

