# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("mscms.dll")
prototypes = \
    {
        #
        'SpoolerCopyFileEvent': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPrinterName", "pszKey", "dwCopyFileEvent"]),
        #
        'GenerateCopyFilePaths': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszPrinterName", "pszDirectory", "pSplClientInfo", "dwLevel", "pszSourceDir", "pcchSourceDirSize", "pszTargetDir", "pcchTargetDirSize", "dwFlags"]),
        #
        'OpenColorProfileA': SimTypeFunction([SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "pProfileData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDataSize": SimTypeInt(signed=False, label="UInt32")}, name="PROFILE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pProfile", "dwDesiredAccess", "dwShareMode", "dwCreationMode"]),
        #
        'OpenColorProfileW': SimTypeFunction([SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "pProfileData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDataSize": SimTypeInt(signed=False, label="UInt32")}, name="PROFILE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pProfile", "dwDesiredAccess", "dwShareMode", "dwCreationMode"]),
        #
        'CloseColorProfile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile"]),
        #
        'GetColorProfileFromHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "pProfile", "pcbProfile"]),
        #
        'IsColorProfileValid': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "pbValid"]),
        #
        'CreateProfileFromLogColorSpaceA': SimTypeFunction([SimTypePointer(SimStruct({"lcsSignature": SimTypeInt(signed=False, label="UInt32"), "lcsVersion": SimTypeInt(signed=False, label="UInt32"), "lcsSize": SimTypeInt(signed=False, label="UInt32"), "lcsCSType": SimTypeInt(signed=True, label="Int32"), "lcsIntent": SimTypeInt(signed=True, label="Int32"), "lcsEndpoints": SimStruct({"ciexyzRed": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzGreen": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzBlue": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None)}, name="CIEXYZTRIPLE", pack=False, align=None), "lcsGammaRed": SimTypeInt(signed=False, label="UInt32"), "lcsGammaGreen": SimTypeInt(signed=False, label="UInt32"), "lcsGammaBlue": SimTypeInt(signed=False, label="UInt32"), "lcsFilename": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 260)}, name="LOGCOLORSPACEA", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pLogColorSpace", "pProfile"]),
        #
        'CreateProfileFromLogColorSpaceW': SimTypeFunction([SimTypePointer(SimStruct({"lcsSignature": SimTypeInt(signed=False, label="UInt32"), "lcsVersion": SimTypeInt(signed=False, label="UInt32"), "lcsSize": SimTypeInt(signed=False, label="UInt32"), "lcsCSType": SimTypeInt(signed=True, label="Int32"), "lcsIntent": SimTypeInt(signed=True, label="Int32"), "lcsEndpoints": SimStruct({"ciexyzRed": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzGreen": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzBlue": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None)}, name="CIEXYZTRIPLE", pack=False, align=None), "lcsGammaRed": SimTypeInt(signed=False, label="UInt32"), "lcsGammaGreen": SimTypeInt(signed=False, label="UInt32"), "lcsGammaBlue": SimTypeInt(signed=False, label="UInt32"), "lcsFilename": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="LOGCOLORSPACEW", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pLogColorSpace", "pProfile"]),
        #
        'GetCountColorProfileElements': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "pnElementCount"]),
        #
        'GetColorProfileHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"phSize": SimTypeInt(signed=False, label="UInt32"), "phCMMType": SimTypeInt(signed=False, label="UInt32"), "phVersion": SimTypeInt(signed=False, label="UInt32"), "phClass": SimTypeInt(signed=False, label="UInt32"), "phDataColorSpace": SimTypeInt(signed=False, label="UInt32"), "phConnectionSpace": SimTypeInt(signed=False, label="UInt32"), "phDateTime": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 3), "phSignature": SimTypeInt(signed=False, label="UInt32"), "phPlatform": SimTypeInt(signed=False, label="UInt32"), "phProfileFlags": SimTypeInt(signed=False, label="UInt32"), "phManufacturer": SimTypeInt(signed=False, label="UInt32"), "phModel": SimTypeInt(signed=False, label="UInt32"), "phAttributes": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "phRenderingIntent": SimTypeInt(signed=False, label="UInt32"), "phIlluminant": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "phCreator": SimTypeInt(signed=False, label="UInt32"), "phReserved": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 44)}, name="PROFILEHEADER", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "pHeader"]),
        #
        'GetColorProfileElementTag': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "dwIndex", "pTag"]),
        #
        'IsColorProfileTagPresent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "tag", "pbPresent"]),
        #
        'GetColorProfileElement': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "tag", "dwOffset", "pcbElement", "pElement", "pbReference"]),
        #
        'SetColorProfileHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"phSize": SimTypeInt(signed=False, label="UInt32"), "phCMMType": SimTypeInt(signed=False, label="UInt32"), "phVersion": SimTypeInt(signed=False, label="UInt32"), "phClass": SimTypeInt(signed=False, label="UInt32"), "phDataColorSpace": SimTypeInt(signed=False, label="UInt32"), "phConnectionSpace": SimTypeInt(signed=False, label="UInt32"), "phDateTime": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 3), "phSignature": SimTypeInt(signed=False, label="UInt32"), "phPlatform": SimTypeInt(signed=False, label="UInt32"), "phProfileFlags": SimTypeInt(signed=False, label="UInt32"), "phManufacturer": SimTypeInt(signed=False, label="UInt32"), "phModel": SimTypeInt(signed=False, label="UInt32"), "phAttributes": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "phRenderingIntent": SimTypeInt(signed=False, label="UInt32"), "phIlluminant": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "phCreator": SimTypeInt(signed=False, label="UInt32"), "phReserved": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 44)}, name="PROFILEHEADER", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "pHeader"]),
        #
        'SetColorProfileElementSize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "tagType", "pcbElement"]),
        #
        'SetColorProfileElement': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "tag", "dwOffset", "pcbElement", "pElement"]),
        #
        'SetColorProfileElementReference': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "newTag", "refTag"]),
        #
        'GetPS2ColorSpaceArray': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "dwIntent", "dwCSAType", "pPS2ColorSpaceArray", "pcbPS2ColorSpaceArray", "pbBinary"]),
        #
        'GetPS2ColorRenderingIntent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "dwIntent", "pBuffer", "pcbPS2ColorRenderingIntent"]),
        #
        'GetPS2ColorRenderingDictionary': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "dwIntent", "pPS2ColorRenderingDictionary", "pcbPS2ColorRenderingDictionary", "pbBinary"]),
        #
        'GetNamedProfileInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwCount": SimTypeInt(signed=False, label="UInt32"), "dwCountDevCoordinates": SimTypeInt(signed=False, label="UInt32"), "szPrefix": SimTypeFixedSizeArray(SimTypeChar(label="SByte"), 32), "szSuffix": SimTypeFixedSizeArray(SimTypeChar(label="SByte"), 32)}, name="NAMED_PROFILE_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "pNamedProfileInfo"]),
        #
        'ConvertColorNameToIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "paColorName", "paIndex", "dwCount"]),
        #
        'ConvertIndexToColorName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "paIndex", "paColorName", "dwCount"]),
        #
        'CreateDeviceLinkProfile': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProfile", "nProfiles", "padwIntent", "nIntents", "dwFlags", "pProfileData", "indexPreferredCMM"]),
        #
        'CreateColorTransformA': SimTypeFunction([SimTypePointer(SimStruct({"lcsSignature": SimTypeInt(signed=False, label="UInt32"), "lcsVersion": SimTypeInt(signed=False, label="UInt32"), "lcsSize": SimTypeInt(signed=False, label="UInt32"), "lcsCSType": SimTypeInt(signed=True, label="Int32"), "lcsIntent": SimTypeInt(signed=True, label="Int32"), "lcsEndpoints": SimStruct({"ciexyzRed": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzGreen": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzBlue": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None)}, name="CIEXYZTRIPLE", pack=False, align=None), "lcsGammaRed": SimTypeInt(signed=False, label="UInt32"), "lcsGammaGreen": SimTypeInt(signed=False, label="UInt32"), "lcsGammaBlue": SimTypeInt(signed=False, label="UInt32"), "lcsFilename": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 260)}, name="LOGCOLORSPACEA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pLogColorSpace", "hDestProfile", "hTargetProfile", "dwFlags"]),
        #
        'CreateColorTransformW': SimTypeFunction([SimTypePointer(SimStruct({"lcsSignature": SimTypeInt(signed=False, label="UInt32"), "lcsVersion": SimTypeInt(signed=False, label="UInt32"), "lcsSize": SimTypeInt(signed=False, label="UInt32"), "lcsCSType": SimTypeInt(signed=True, label="Int32"), "lcsIntent": SimTypeInt(signed=True, label="Int32"), "lcsEndpoints": SimStruct({"ciexyzRed": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzGreen": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None), "ciexyzBlue": SimStruct({"ciexyzX": SimTypeInt(signed=True, label="Int32"), "ciexyzY": SimTypeInt(signed=True, label="Int32"), "ciexyzZ": SimTypeInt(signed=True, label="Int32")}, name="CIEXYZ", pack=False, align=None)}, name="CIEXYZTRIPLE", pack=False, align=None), "lcsGammaRed": SimTypeInt(signed=False, label="UInt32"), "lcsGammaGreen": SimTypeInt(signed=False, label="UInt32"), "lcsGammaBlue": SimTypeInt(signed=False, label="UInt32"), "lcsFilename": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="LOGCOLORSPACEW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pLogColorSpace", "hDestProfile", "hTargetProfile", "dwFlags"]),
        #
        'CreateMultiProfileTransform': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pahProfiles", "nProfiles", "padwIntent", "nIntents", "dwFlags", "indexPreferredCMM"]),
        #
        'DeleteColorTransform': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hxform"]),
        #
        'TranslateBitmapBits': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="BMFORMAT"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="BMFORMAT"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hColorTransform", "pSrcBits", "bmInput", "dwWidth", "dwHeight", "dwInputStride", "pDestBits", "bmOutput", "dwOutputStride", "pfnCallBack", "ulCallbackData"]),
        #
        'CheckBitmapBits': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="BMFORMAT"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["param0", "param1", "param2"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hColorTransform", "pSrcBits", "bmInput", "dwWidth", "dwHeight", "dwStride", "paResult", "pfnCallback", "lpCallbackData"]),
        #
        'TranslateColors': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimUnion({"gray": SimStruct({"gray": SimTypeShort(signed=False, label="UInt16")}, name="GRAYCOLOR", pack=False, align=None), "rgb": SimStruct({"red": SimTypeShort(signed=False, label="UInt16"), "green": SimTypeShort(signed=False, label="UInt16"), "blue": SimTypeShort(signed=False, label="UInt16")}, name="RGBCOLOR", pack=False, align=None), "cmyk": SimStruct({"cyan": SimTypeShort(signed=False, label="UInt16"), "magenta": SimTypeShort(signed=False, label="UInt16"), "yellow": SimTypeShort(signed=False, label="UInt16"), "black": SimTypeShort(signed=False, label="UInt16")}, name="CMYKCOLOR", pack=False, align=None), "XYZ": SimStruct({"X": SimTypeShort(signed=False, label="UInt16"), "Y": SimTypeShort(signed=False, label="UInt16"), "Z": SimTypeShort(signed=False, label="UInt16")}, name="XYZCOLOR", pack=False, align=None), "Yxy": SimStruct({"Y": SimTypeShort(signed=False, label="UInt16"), "x": SimTypeShort(signed=False, label="UInt16"), "y": SimTypeShort(signed=False, label="UInt16")}, name="YxyCOLOR", pack=False, align=None), "Lab": SimStruct({"L": SimTypeShort(signed=False, label="UInt16"), "a": SimTypeShort(signed=False, label="UInt16"), "b": SimTypeShort(signed=False, label="UInt16")}, name="LabCOLOR", pack=False, align=None), "gen3ch": SimStruct({"ch1": SimTypeShort(signed=False, label="UInt16"), "ch2": SimTypeShort(signed=False, label="UInt16"), "ch3": SimTypeShort(signed=False, label="UInt16")}, name="GENERIC3CHANNEL", pack=False, align=None), "named": SimStruct({"dwIndex": SimTypeInt(signed=False, label="UInt32")}, name="NAMEDCOLOR", pack=False, align=None), "hifi": SimStruct({"channel": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="HiFiCOLOR", pack=False, align=None), "Anonymous": SimStruct({"reserved1": SimTypeInt(signed=False, label="UInt32"), "reserved2": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="COLORTYPE"), SimTypePointer(SimUnion({"gray": SimStruct({"gray": SimTypeShort(signed=False, label="UInt16")}, name="GRAYCOLOR", pack=False, align=None), "rgb": SimStruct({"red": SimTypeShort(signed=False, label="UInt16"), "green": SimTypeShort(signed=False, label="UInt16"), "blue": SimTypeShort(signed=False, label="UInt16")}, name="RGBCOLOR", pack=False, align=None), "cmyk": SimStruct({"cyan": SimTypeShort(signed=False, label="UInt16"), "magenta": SimTypeShort(signed=False, label="UInt16"), "yellow": SimTypeShort(signed=False, label="UInt16"), "black": SimTypeShort(signed=False, label="UInt16")}, name="CMYKCOLOR", pack=False, align=None), "XYZ": SimStruct({"X": SimTypeShort(signed=False, label="UInt16"), "Y": SimTypeShort(signed=False, label="UInt16"), "Z": SimTypeShort(signed=False, label="UInt16")}, name="XYZCOLOR", pack=False, align=None), "Yxy": SimStruct({"Y": SimTypeShort(signed=False, label="UInt16"), "x": SimTypeShort(signed=False, label="UInt16"), "y": SimTypeShort(signed=False, label="UInt16")}, name="YxyCOLOR", pack=False, align=None), "Lab": SimStruct({"L": SimTypeShort(signed=False, label="UInt16"), "a": SimTypeShort(signed=False, label="UInt16"), "b": SimTypeShort(signed=False, label="UInt16")}, name="LabCOLOR", pack=False, align=None), "gen3ch": SimStruct({"ch1": SimTypeShort(signed=False, label="UInt16"), "ch2": SimTypeShort(signed=False, label="UInt16"), "ch3": SimTypeShort(signed=False, label="UInt16")}, name="GENERIC3CHANNEL", pack=False, align=None), "named": SimStruct({"dwIndex": SimTypeInt(signed=False, label="UInt32")}, name="NAMEDCOLOR", pack=False, align=None), "hifi": SimStruct({"channel": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="HiFiCOLOR", pack=False, align=None), "Anonymous": SimStruct({"reserved1": SimTypeInt(signed=False, label="UInt32"), "reserved2": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), label="LPArray", offset=0), SimTypeInt(signed=False, label="COLORTYPE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hColorTransform", "paInputColors", "nColors", "ctInput", "paOutputColors", "ctOutput"]),
        #
        'CheckColors': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimUnion({"gray": SimStruct({"gray": SimTypeShort(signed=False, label="UInt16")}, name="GRAYCOLOR", pack=False, align=None), "rgb": SimStruct({"red": SimTypeShort(signed=False, label="UInt16"), "green": SimTypeShort(signed=False, label="UInt16"), "blue": SimTypeShort(signed=False, label="UInt16")}, name="RGBCOLOR", pack=False, align=None), "cmyk": SimStruct({"cyan": SimTypeShort(signed=False, label="UInt16"), "magenta": SimTypeShort(signed=False, label="UInt16"), "yellow": SimTypeShort(signed=False, label="UInt16"), "black": SimTypeShort(signed=False, label="UInt16")}, name="CMYKCOLOR", pack=False, align=None), "XYZ": SimStruct({"X": SimTypeShort(signed=False, label="UInt16"), "Y": SimTypeShort(signed=False, label="UInt16"), "Z": SimTypeShort(signed=False, label="UInt16")}, name="XYZCOLOR", pack=False, align=None), "Yxy": SimStruct({"Y": SimTypeShort(signed=False, label="UInt16"), "x": SimTypeShort(signed=False, label="UInt16"), "y": SimTypeShort(signed=False, label="UInt16")}, name="YxyCOLOR", pack=False, align=None), "Lab": SimStruct({"L": SimTypeShort(signed=False, label="UInt16"), "a": SimTypeShort(signed=False, label="UInt16"), "b": SimTypeShort(signed=False, label="UInt16")}, name="LabCOLOR", pack=False, align=None), "gen3ch": SimStruct({"ch1": SimTypeShort(signed=False, label="UInt16"), "ch2": SimTypeShort(signed=False, label="UInt16"), "ch3": SimTypeShort(signed=False, label="UInt16")}, name="GENERIC3CHANNEL", pack=False, align=None), "named": SimStruct({"dwIndex": SimTypeInt(signed=False, label="UInt32")}, name="NAMEDCOLOR", pack=False, align=None), "hifi": SimStruct({"channel": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8)}, name="HiFiCOLOR", pack=False, align=None), "Anonymous": SimStruct({"reserved1": SimTypeInt(signed=False, label="UInt32"), "reserved2": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="COLORTYPE"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hColorTransform", "paInputColors", "nColors", "ctInput", "paResult"]),
        #
        'GetCMMInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hColorTransform", "param1"]),
        #
        'RegisterCMMA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "cmmID", "pCMMdll"]),
        #
        'RegisterCMMW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "cmmID", "pCMMdll"]),
        #
        'UnregisterCMMA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "cmmID"]),
        #
        'UnregisterCMMW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "cmmID"]),
        #
        'SelectCMM': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCMMType"]),
        #
        'GetColorDirectoryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pBuffer", "pdwSize"]),
        #
        'GetColorDirectoryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pBuffer", "pdwSize"]),
        #
        'InstallColorProfileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pProfileName"]),
        #
        'InstallColorProfileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pProfileName"]),
        #
        'UninstallColorProfileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pProfileName", "bDelete"]),
        #
        'UninstallColorProfileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pProfileName", "bDelete"]),
        #
        'EnumColorProfilesA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFields": SimTypeInt(signed=False, label="UInt32"), "pDeviceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwMediaType": SimTypeInt(signed=False, label="UInt32"), "dwDitheringMode": SimTypeInt(signed=False, label="UInt32"), "dwResolution": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "dwCMMType": SimTypeInt(signed=False, label="UInt32"), "dwClass": SimTypeInt(signed=False, label="UInt32"), "dwDataColorSpace": SimTypeInt(signed=False, label="UInt32"), "dwConnectionSpace": SimTypeInt(signed=False, label="UInt32"), "dwSignature": SimTypeInt(signed=False, label="UInt32"), "dwPlatform": SimTypeInt(signed=False, label="UInt32"), "dwProfileFlags": SimTypeInt(signed=False, label="UInt32"), "dwManufacturer": SimTypeInt(signed=False, label="UInt32"), "dwModel": SimTypeInt(signed=False, label="UInt32"), "dwAttributes": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "dwRenderingIntent": SimTypeInt(signed=False, label="UInt32"), "dwCreator": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClass": SimTypeInt(signed=False, label="UInt32")}, name="ENUMTYPEA", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pEnumRecord", "pEnumerationBuffer", "pdwSizeOfEnumerationBuffer", "pnProfiles"]),
        #
        'EnumColorProfilesW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFields": SimTypeInt(signed=False, label="UInt32"), "pDeviceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwMediaType": SimTypeInt(signed=False, label="UInt32"), "dwDitheringMode": SimTypeInt(signed=False, label="UInt32"), "dwResolution": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "dwCMMType": SimTypeInt(signed=False, label="UInt32"), "dwClass": SimTypeInt(signed=False, label="UInt32"), "dwDataColorSpace": SimTypeInt(signed=False, label="UInt32"), "dwConnectionSpace": SimTypeInt(signed=False, label="UInt32"), "dwSignature": SimTypeInt(signed=False, label="UInt32"), "dwPlatform": SimTypeInt(signed=False, label="UInt32"), "dwProfileFlags": SimTypeInt(signed=False, label="UInt32"), "dwManufacturer": SimTypeInt(signed=False, label="UInt32"), "dwModel": SimTypeInt(signed=False, label="UInt32"), "dwAttributes": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "dwRenderingIntent": SimTypeInt(signed=False, label="UInt32"), "dwCreator": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClass": SimTypeInt(signed=False, label="UInt32")}, name="ENUMTYPEW", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pEnumRecord", "pEnumerationBuffer", "pdwSizeOfEnumerationBuffer", "pnProfiles"]),
        #
        'SetStandardColorSpaceProfileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "dwProfileID", "pProfilename"]),
        #
        'SetStandardColorSpaceProfileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "dwProfileID", "pProfileName"]),
        #
        'GetStandardColorSpaceProfileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "dwSCS", "pBuffer", "pcbSize"]),
        #
        'GetStandardColorSpaceProfileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "dwSCS", "pBuffer", "pcbSize"]),
        #
        'AssociateColorProfileWithDeviceA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pProfileName", "pDeviceName"]),
        #
        'AssociateColorProfileWithDeviceW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pProfileName", "pDeviceName"]),
        #
        'DisassociateColorProfileFromDeviceA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pProfileName", "pDeviceName"]),
        #
        'DisassociateColorProfileFromDeviceW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMachineName", "pProfileName", "pDeviceName"]),
        #
        'WcsAssociateColorProfileWithDevice': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "pProfileName", "pDeviceName"]),
        #
        'WcsDisassociateColorProfileFromDevice': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "pProfileName", "pDeviceName"]),
        #
        'WcsEnumColorProfilesSize': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFields": SimTypeInt(signed=False, label="UInt32"), "pDeviceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwMediaType": SimTypeInt(signed=False, label="UInt32"), "dwDitheringMode": SimTypeInt(signed=False, label="UInt32"), "dwResolution": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "dwCMMType": SimTypeInt(signed=False, label="UInt32"), "dwClass": SimTypeInt(signed=False, label="UInt32"), "dwDataColorSpace": SimTypeInt(signed=False, label="UInt32"), "dwConnectionSpace": SimTypeInt(signed=False, label="UInt32"), "dwSignature": SimTypeInt(signed=False, label="UInt32"), "dwPlatform": SimTypeInt(signed=False, label="UInt32"), "dwProfileFlags": SimTypeInt(signed=False, label="UInt32"), "dwManufacturer": SimTypeInt(signed=False, label="UInt32"), "dwModel": SimTypeInt(signed=False, label="UInt32"), "dwAttributes": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "dwRenderingIntent": SimTypeInt(signed=False, label="UInt32"), "dwCreator": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClass": SimTypeInt(signed=False, label="UInt32")}, name="ENUMTYPEW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "pEnumRecord", "pdwSize"]),
        #
        'WcsEnumColorProfiles': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFields": SimTypeInt(signed=False, label="UInt32"), "pDeviceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwMediaType": SimTypeInt(signed=False, label="UInt32"), "dwDitheringMode": SimTypeInt(signed=False, label="UInt32"), "dwResolution": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "dwCMMType": SimTypeInt(signed=False, label="UInt32"), "dwClass": SimTypeInt(signed=False, label="UInt32"), "dwDataColorSpace": SimTypeInt(signed=False, label="UInt32"), "dwConnectionSpace": SimTypeInt(signed=False, label="UInt32"), "dwSignature": SimTypeInt(signed=False, label="UInt32"), "dwPlatform": SimTypeInt(signed=False, label="UInt32"), "dwProfileFlags": SimTypeInt(signed=False, label="UInt32"), "dwManufacturer": SimTypeInt(signed=False, label="UInt32"), "dwModel": SimTypeInt(signed=False, label="UInt32"), "dwAttributes": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "dwRenderingIntent": SimTypeInt(signed=False, label="UInt32"), "dwCreator": SimTypeInt(signed=False, label="UInt32"), "dwDeviceClass": SimTypeInt(signed=False, label="UInt32")}, name="ENUMTYPEW", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "pEnumRecord", "pBuffer", "dwSize", "pnProfiles"]),
        #
        'WcsGetDefaultColorProfileSize': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="COLORPROFILETYPE"), SimTypeInt(signed=False, label="COLORPROFILESUBTYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "pDeviceName", "cptColorProfileType", "cpstColorProfileSubType", "dwProfileID", "pcbProfileName"]),
        #
        'WcsGetDefaultColorProfile': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="COLORPROFILETYPE"), SimTypeInt(signed=False, label="COLORPROFILESUBTYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "pDeviceName", "cptColorProfileType", "cpstColorProfileSubType", "dwProfileID", "cbProfileName", "pProfileName"]),
        #
        'WcsSetDefaultColorProfile': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="COLORPROFILETYPE"), SimTypeInt(signed=False, label="COLORPROFILESUBTYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "pDeviceName", "cptColorProfileType", "cpstColorProfileSubType", "dwProfileID", "pProfileName"]),
        #
        'WcsSetDefaultRenderingIntent': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "dwRenderingIntent"]),
        #
        'WcsGetDefaultRenderingIntent': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "pdwRenderingIntent"]),
        #
        'WcsGetUsePerUserProfiles': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pDeviceName", "dwDeviceClass", "pUsePerUserProfiles"]),
        #
        'WcsSetUsePerUserProfiles': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pDeviceName", "dwDeviceClass", "usePerUserProfiles"]),
        #
        'WcsTranslateColors': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="COLORDATATYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="COLORDATATYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hColorTransform", "nColors", "nInputChannels", "cdtInput", "cbInput", "pInputData", "nOutputChannels", "cdtOutput", "cbOutput", "pOutputData"]),
        #
        'WcsCheckColors': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="COLORDATATYPE"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hColorTransform", "nColors", "nInputChannels", "cdtInput", "cbInput", "pInputData", "paResult"]),
        #
        'WcsOpenColorProfileA': SimTypeFunction([SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "pProfileData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDataSize": SimTypeInt(signed=False, label="UInt32")}, name="PROFILE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "pProfileData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDataSize": SimTypeInt(signed=False, label="UInt32")}, name="PROFILE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "pProfileData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDataSize": SimTypeInt(signed=False, label="UInt32")}, name="PROFILE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pCDMPProfile", "pCAMPProfile", "pGMMPProfile", "dwDesireAccess", "dwShareMode", "dwCreationMode", "dwFlags"]),
        #
        'WcsOpenColorProfileW': SimTypeFunction([SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "pProfileData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDataSize": SimTypeInt(signed=False, label="UInt32")}, name="PROFILE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "pProfileData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDataSize": SimTypeInt(signed=False, label="UInt32")}, name="PROFILE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "pProfileData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbDataSize": SimTypeInt(signed=False, label="UInt32")}, name="PROFILE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pCDMPProfile", "pCAMPProfile", "pGMMPProfile", "dwDesireAccess", "dwShareMode", "dwCreationMode", "dwFlags"]),
        #
        'WcsCreateIccProfile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWcsProfile", "dwOptions"]),
        #
        'WcsGetCalibrationManagementState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pbIsEnabled"]),
        #
        'WcsSetCalibrationManagementState': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["bIsEnabled"]),
        #
        'ColorAdapterGetSystemModifyWhitePointCaps': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["whitePointAdjCapable", "isColorOverrideActive"]),
        #
        'ColorAdapterUpdateDisplayGamma': SimTypeFunction([SimStruct({"targetAdapterID": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), "sourceInfoID": SimTypeInt(signed=False, label="UInt32")}, name="DisplayID", pack=False, align=None), SimTypePointer(SimStruct({"red": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "green": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "blue": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256)}, name="DisplayTransformLut", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["displayID", "displayTransform", "internal"]),
        #
        'ColorAdapterUpdateDeviceProfile': SimTypeFunction([SimStruct({"targetAdapterID": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), "sourceInfoID": SimTypeInt(signed=False, label="UInt32")}, name="DisplayID", pack=False, align=None), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["displayID", "profName"]),
        #
        'ColorAdapterGetDisplayCurrentStateID': SimTypeFunction([SimStruct({"targetAdapterID": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), "sourceInfoID": SimTypeInt(signed=False, label="UInt32")}, name="DisplayID", pack=False, align=None), SimTypePointer(SimStruct({"profileID": SimTypeInt(signed=False, label="UInt32"), "transformID": SimTypeInt(signed=False, label="UInt32"), "whitepointID": SimTypeInt(signed=False, label="UInt32")}, name="DisplayStateID", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["displayID", "displayStateID"]),
        #
        'ColorAdapterGetDisplayTransformData': SimTypeFunction([SimStruct({"targetAdapterID": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), "sourceInfoID": SimTypeInt(signed=False, label="UInt32")}, name="DisplayID", pack=False, align=None), SimTypePointer(SimStruct({"red": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "green": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "blue": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256)}, name="DisplayTransformLut", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["displayID", "displayTransformLut", "transformID"]),
        #
        'ColorAdapterGetDisplayTargetWhitePoint': SimTypeFunction([SimStruct({"targetAdapterID": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), "sourceInfoID": SimTypeInt(signed=False, label="UInt32")}, name="DisplayID", pack=False, align=None), SimTypePointer(SimStruct({"type": SimTypeInt(signed=True, label="Int32"), "Anonymous": SimUnion({"xyY": SimStruct({"x": SimTypeFloat(size=32), "y": SimTypeFloat(size=32), "Y": SimTypeFloat(size=32)}, name="XYYPoint", pack=False, align=None), "CCT": SimTypeFloat(size=32)}, name="<anon>", label="None")}, name="WhitePoint", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["displayID", "wtpt", "transitionTime", "whitepointID"]),
        #
        'ColorAdapterGetDisplayProfile': SimTypeFunction([SimStruct({"targetAdapterID": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), "sourceInfoID": SimTypeInt(signed=False, label="UInt32")}, name="DisplayID", pack=False, align=None), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["displayID", "displayProfile", "profileID", "bUseAccurate"]),
        #
        'ColorAdapterGetCurrentProfileCalibration': SimTypeFunction([SimStruct({"targetAdapterID": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), "sourceInfoID": SimTypeInt(signed=False, label="UInt32")}, name="DisplayID", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["displayID", "maxCalibrationBlobSize", "blobSize", "calibrationBlob"]),
        #
        'ColorAdapterRegisterOEMColorService': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["registration"]),
        #
        'ColorAdapterUnregisterOEMColorService': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["registration"]),
        #
        'ColorProfileAddDisplayAssociation': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "profileName", "targetAdapterID", "sourceID", "setAsDefault", "associateAsAdvancedColor"]),
        #
        'ColorProfileRemoveDisplayAssociation': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "profileName", "targetAdapterID", "sourceID", "dissociateAdvancedColor"]),
        #
        'ColorProfileSetDisplayDefaultAssociation': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="COLORPROFILETYPE"), SimTypeInt(signed=False, label="COLORPROFILESUBTYPE"), SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "profileName", "profileType", "profileSubType", "targetAdapterID", "sourceID"]),
        #
        'ColorProfileGetDisplayList': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "targetAdapterID", "sourceID", "profileList", "profileCount"]),
        #
        'ColorProfileGetDisplayDefault': SimTypeFunction([SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="COLORPROFILETYPE"), SimTypeInt(signed=False, label="COLORPROFILESUBTYPE"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["scope", "targetAdapterID", "sourceID", "profileType", "profileSubType", "profileName"]),
        #
        'ColorProfileGetDisplayUserScope': SimTypeFunction([SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="LUID", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="WCS_PROFILE_MANAGEMENT_SCOPE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["targetAdapterID", "sourceID", "scope"]),
    }

lib.set_prototypes(prototypes)
