/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo.settings;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.tasklist.todo.settings.ExtensionIdentifier;
import org.netbeans.modules.tasklist.todo.settings.FileIdentifier;
import org.netbeans.modules.tasklist.todo.settings.MimeIdentifier;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class IdentifierPickerPanel
extends JPanel {
    private final List<MimeIdentifier> availableMimes;
    private final List<ExtensionIdentifier> supportedExtensions;
    private boolean lastValid = false;
    private ButtonGroup buttonGroup1;
    private JScrollPane jScrollPane1;
    private JList listMime;
    private JRadioButton rbExtension;
    private JRadioButton rbMime;
    private JTextField textExtension;

    public IdentifierPickerPanel(List<MimeIdentifier> availableMimes, List<ExtensionIdentifier> supportedExtensions) {
        this.availableMimes = availableMimes;
        this.supportedExtensions = supportedExtensions;
        this.initComponents();
        this.initList();
    }

    List<FileIdentifier> getSelectedMimeTypes() {
        ArrayList<FileIdentifier> selectedIdentifiers = new ArrayList<FileIdentifier>();
        if (this.rbMime.isSelected()) {
            int[] selectedIndices;
            for (int i : selectedIndices = this.listMime.getSelectedIndices()) {
                selectedIdentifiers.add(this.availableMimes.get(i));
            }
        } else {
            selectedIdentifiers.add(new ExtensionIdentifier(this.textExtension.getText()));
        }
        return selectedIdentifiers;
    }

    private void initList() {
        this.listMime.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return IdentifierPickerPanel.this.availableMimes.size();
            }

            @Override
            public Object getElementAt(int index) {
                return ((MimeIdentifier)IdentifierPickerPanel.this.availableMimes.get(index)).getDisplayName();
            }
        });
    }

    private boolean isSelectionValid() {
        if (this.rbExtension.isSelected()) {
            String extension = this.textExtension.getText();
            return extension != null && extension.length() != 0 && extension.indexOf(".") == -1 && this.isExtensionAvailable(extension);
        }
        return this.listMime.getSelectedIndex() != -1;
    }

    private boolean isExtensionAvailable(String extension) {
        for (ExtensionIdentifier extensionIdentifier : this.supportedExtensions) {
            if (!extensionIdentifier.getDisplayName().equalsIgnoreCase(extension)) continue;
            return false;
        }
        return true;
    }

    void addValidityListener(final NotifyDescriptor descriptor) {
        descriptor.setValid(this.isSelectionValid());
        this.textExtension.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                descriptor.setValid(IdentifierPickerPanel.this.isSelectionValid());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                descriptor.setValid(IdentifierPickerPanel.this.isSelectionValid());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                descriptor.setValid(IdentifierPickerPanel.this.isSelectionValid());
            }
        });
        this.listMime.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                descriptor.setValid(IdentifierPickerPanel.this.isSelectionValid());
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.listMime = new JList();
        this.rbMime = new JRadioButton();
        this.rbExtension = new JRadioButton();
        this.textExtension = new JTextField();
        this.listMime.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.listMime);
        this.buttonGroup1.add(this.rbMime);
        this.rbMime.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbMime, (String)NbBundle.getMessage(IdentifierPickerPanel.class, (String)"IdentifierPickerPanel.rbMime.text"));
        this.rbMime.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                IdentifierPickerPanel.this.rbMimeStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.rbExtension);
        Mnemonics.setLocalizedText((AbstractButton)this.rbExtension, (String)NbBundle.getMessage(IdentifierPickerPanel.class, (String)"IdentifierPickerPanel.rbExtension.text"));
        this.rbExtension.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                IdentifierPickerPanel.this.rbExtensionStateChanged(evt);
            }
        });
        this.textExtension.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1)).addGroup(layout.createSequentialGroup().addComponent(this.rbExtension).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textExtension, -2, 219, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.rbMime).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.rbMime).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 173, -2).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbExtension).addComponent(this.textExtension, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void rbMimeStateChanged(ChangeEvent evt) {
        this.listMime.setEnabled(this.rbMime.isSelected());
    }

    private void rbExtensionStateChanged(ChangeEvent evt) {
        this.textExtension.setEnabled(this.rbExtension.isSelected());
    }
}

