/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.InstanceConfigurationInstanceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class LaunchInstanceConfigurationRequest
extends BmcRequest<InstanceConfigurationInstanceDetails> {
    private String instanceConfigurationId;
    private InstanceConfigurationInstanceDetails instanceConfiguration;
    private String opcRetryToken;

    public String getInstanceConfigurationId() {
        return this.instanceConfigurationId;
    }

    public InstanceConfigurationInstanceDetails getInstanceConfiguration() {
        return this.instanceConfiguration;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public InstanceConfigurationInstanceDetails getBody$() {
        return this.instanceConfiguration;
    }

    public Builder toBuilder() {
        return new Builder().instanceConfigurationId(this.instanceConfigurationId).instanceConfiguration(this.instanceConfiguration).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceConfigurationId=").append(String.valueOf(this.instanceConfigurationId));
        sb.append(",instanceConfiguration=").append(String.valueOf((Object)this.instanceConfiguration));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LaunchInstanceConfigurationRequest)) {
            return false;
        }
        LaunchInstanceConfigurationRequest other = (LaunchInstanceConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceConfigurationId, other.instanceConfigurationId) && Objects.equals((Object)this.instanceConfiguration, (Object)other.instanceConfiguration) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceConfigurationId == null ? 43 : this.instanceConfigurationId.hashCode());
        result = result * 59 + (this.instanceConfiguration == null ? 43 : this.instanceConfiguration.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<LaunchInstanceConfigurationRequest, InstanceConfigurationInstanceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceConfigurationId = null;
        private InstanceConfigurationInstanceDetails instanceConfiguration = null;
        private String opcRetryToken = null;

        public Builder instanceConfigurationId(String instanceConfigurationId) {
            this.instanceConfigurationId = instanceConfigurationId;
            return this;
        }

        public Builder instanceConfiguration(InstanceConfigurationInstanceDetails instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(LaunchInstanceConfigurationRequest o) {
            this.instanceConfigurationId(o.getInstanceConfigurationId());
            this.instanceConfiguration(o.getInstanceConfiguration());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public LaunchInstanceConfigurationRequest build() {
            LaunchInstanceConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InstanceConfigurationInstanceDetails body) {
            this.instanceConfiguration(body);
            return this;
        }

        public LaunchInstanceConfigurationRequest buildWithoutInvocationCallback() {
            LaunchInstanceConfigurationRequest request = new LaunchInstanceConfigurationRequest();
            request.instanceConfigurationId = this.instanceConfigurationId;
            request.instanceConfiguration = this.instanceConfiguration;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

