/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.rename;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.VersioningQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.groovy.refactoring.rename.RenameRefactoringPlugin;
import org.netbeans.modules.groovy.refactoring.utils.IdentifiersUtil;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RenamePackagePlugin
implements RefactoringPlugin {
    private RenameRefactoring refactoring;
    private FileObject folder;

    public RenamePackagePlugin(FileObject folder, RenameRefactoring refactoring) {
        this.refactoring = refactoring;
        this.folder = folder;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        FileObject ownerRoot;
        String newName = this.refactoring.getNewName();
        if (!IdentifiersUtil.isValidPackageName(newName)) {
            return this.createProblem("ERR_InvalidPackage", newName);
        }
        ClassPath projectClassPath = ClassPath.getClassPath((FileObject)this.folder, (String)"classpath/source");
        FileObject fo = projectClassPath.findResource(newName.replace('.', '/'));
        if (fo != null && (ownerRoot = projectClassPath.findOwnerRoot(this.folder)) != null && ownerRoot.equals(projectClassPath.findOwnerRoot(fo))) {
            FileObject parent;
            String relativePath;
            if (fo.isFolder() && fo.getChildren().length == 1 && (relativePath = FileUtil.getRelativePath((FileObject)(parent = fo.getChildren()[0]), (FileObject)this.folder)) != null) {
                return null;
            }
            return this.createProblem("ERR_PackageExists", newName);
        }
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag elements) {
        elements.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new RenameNonRecursiveFolder(this.folder));
        return null;
    }

    private Problem createProblem(String problemID, String newName) {
        String msg = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)problemID)).format(new Object[]{newName});
        return new Problem(true, msg);
    }

    private class RenameNonRecursiveFolder
    extends SimpleRefactoringElementImplementation {
        private FileObject folder;
        private String oldName;
        private FileObject root;
        private String currentName;

        public RenameNonRecursiveFolder(FileObject folder) {
            this.folder = folder;
            ClassPath classPath = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
            if (classPath != null) {
                this.oldName = this.currentName = classPath.getResourceName(folder, '.', false);
                this.root = classPath.findOwnerRoot(folder);
            }
        }

        public String getText() {
            return NbBundle.getMessage(RenamePackagePlugin.class, (String)"TXT_RenamePackage") + this.folder.getNameExt();
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            this.atomicSetName(RenamePackagePlugin.this.refactoring.getNewName());
        }

        public void undoChange() {
            this.atomicSetName(this.oldName);
        }

        private void atomicSetName(final String name) {
            try {
                this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        RenameNonRecursiveFolder.this.setName(name);
                    }
                });
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.folder.getParent());
        }

        public FileObject getParentFile() {
            return this.folder.getParent();
        }

        public PositionBounds getPosition() {
            return null;
        }

        public void setName(String name) {
            int index;
            int i;
            if (this.currentName.equals(name)) {
                return;
            }
            name = name.replace('.', '/') + '/';
            this.currentName = this.currentName.replace('.', '/') + '/';
            for (i = 0; i < this.currentName.length() && i < name.length() && this.currentName.charAt(i) == name.charAt(i); ++i) {
            }
            String commonPrefix = (index = this.currentName.lastIndexOf(47, --i)) == -1 ? null : this.currentName.substring(0, index);
            String toCreate = index + 1 == name.length() ? "" : name.substring(index + 1);
            try {
                FileObject commonFolder;
                FileObject destination = commonFolder = commonPrefix == null ? this.root : this.root.getFileObject(commonPrefix);
                StringTokenizer dtk = new StringTokenizer(toCreate, "/");
                while (dtk.hasMoreTokens()) {
                    String pathElement = dtk.nextToken();
                    FileObject tmp = destination.getFileObject(pathElement);
                    if (tmp == null) {
                        tmp = destination.createFolder(pathElement);
                    }
                    destination = tmp;
                }
                if (!this.folder.isValid()) {
                    this.folder = FileUtil.toFileObject((File)new File(this.folder.getPath()));
                }
                FileObject folder = this.folder;
                FileUtil.toFileObject((File)new File(this.folder.getPath()));
                DataFolder sourceFolder = DataFolder.findFolder((FileObject)folder);
                DataFolder destinationFolder = DataFolder.findFolder((FileObject)destination);
                DataObject[] children = sourceFolder.getChildren();
                for (int j = 0; j < children.length; ++j) {
                    if (!children[j].getPrimaryFile().isData()) continue;
                    children[j].move(destinationFolder);
                }
                while (!commonFolder.equals(folder) && this.isEmpty(folder)) {
                    FileObject tmp = folder;
                    folder = folder.getParent();
                    tmp.delete();
                }
                this.folder = destinationFolder.getPrimaryFile();
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
            this.currentName = name;
        }

        private boolean isEmpty(FileObject folder) {
            if (VersioningQuery.isManaged((URI)folder.toURI())) {
                for (FileObject child : folder.getChildren()) {
                    if (!VisibilityQuery.getDefault().isVisible(child)) continue;
                    return false;
                }
                return true;
            }
            return folder.getChildren().length == 0;
        }
    }
}

