/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.BulkEditTagsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class BulkEditTagsRequest
extends BmcRequest<BulkEditTagsDetails> {
    private String opcRequestId;
    private String opcRetryToken;
    private BulkEditTagsDetails bulkEditTagsDetails;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public BulkEditTagsDetails getBulkEditTagsDetails() {
        return this.bulkEditTagsDetails;
    }

    @InternalSdk
    public BulkEditTagsDetails getBody$() {
        return this.bulkEditTagsDetails;
    }

    public Builder toBuilder() {
        return new Builder().opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).bulkEditTagsDetails(this.bulkEditTagsDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",bulkEditTagsDetails=").append(String.valueOf((Object)this.bulkEditTagsDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkEditTagsRequest)) {
            return false;
        }
        BulkEditTagsRequest other = (BulkEditTagsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals((Object)this.bulkEditTagsDetails, (Object)other.bulkEditTagsDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.bulkEditTagsDetails == null ? 43 : this.bulkEditTagsDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BulkEditTagsRequest, BulkEditTagsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private BulkEditTagsDetails bulkEditTagsDetails = null;

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder bulkEditTagsDetails(BulkEditTagsDetails bulkEditTagsDetails) {
            this.bulkEditTagsDetails = bulkEditTagsDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BulkEditTagsRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.bulkEditTagsDetails(o.getBulkEditTagsDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BulkEditTagsRequest build() {
            BulkEditTagsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BulkEditTagsDetails body) {
            this.bulkEditTagsDetails(body);
            return this;
        }

        public BulkEditTagsRequest buildWithoutInvocationCallback() {
            BulkEditTagsRequest request = new BulkEditTagsRequest();
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.bulkEditTagsDetails = this.bulkEditTagsDetails;
            return request;
        }
    }
}

