/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.builder.AbstractMarkupDocumentBuilder;

public class MarkdownDocumentBuilder
extends AbstractMarkupDocumentBuilder {
    private static final Pattern PATTERN_LINE_BREAK = Pattern.compile("(.*(\r\n|\r|\n)?)?");
    private final Map<String, String> entityToLiteral = new HashMap<String, String>();

    public MarkdownDocumentBuilder(Writer out) {
        super(out);
        this.entityToLiteral.put("amp", "&");
        this.entityToLiteral.put("lt", "<");
        this.entityToLiteral.put("gt", ">");
        this.currentBlock = null;
    }

    protected AbstractMarkupDocumentBuilder.Block computeBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        switch (type) {
            case PARAGRAPH: {
                return new ContentBlock(type, "", "", 2, 2);
            }
            case QUOTE: {
                return new PrefixedLineContentBlock(type, "> ", "", 1, 1);
            }
            case NUMERIC_LIST: 
            case BULLETED_LIST: {
                DocumentBuilder.BlockType currentBlockType;
                if (this.currentBlock != null && ((currentBlockType = this.currentBlock.getBlockType()) == DocumentBuilder.BlockType.LIST_ITEM || currentBlockType == DocumentBuilder.BlockType.DEFINITION_ITEM || currentBlockType == DocumentBuilder.BlockType.DEFINITION_TERM)) {
                    return new ListBlock(type, 1);
                }
                return new ListBlock(type, 2);
            }
            case LIST_ITEM: {
                if (this.computeCurrentListType() == DocumentBuilder.BlockType.NUMERIC_LIST) {
                    return new ListItemBlock("1. ");
                }
                return new ListItemBlock("* ");
            }
            case CODE: {
                return new PrefixedLineContentBlock(type, "    ", "", 1, 2);
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected block type: " + type);
        return new ContentBlock(type, "", "", 2, 2);
    }

    protected AbstractMarkupDocumentBuilder.Block computeSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        switch (type) {
            case LINK: {
                if (attributes instanceof LinkAttributes) {
                    return new LinkBlock((LinkAttributes)attributes);
                }
                return new ContentBlock("<", ">", 0, 0);
            }
            case EMPHASIS: 
            case ITALIC: {
                return new ContentBlock("*", "*", 0, 0);
            }
            case STRONG: 
            case BOLD: {
                return new ContentBlock("**", "**", 0, 0);
            }
            case CODE: {
                return new CodeSpan();
            }
        }
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Unexpected block type: " + type);
        return new ContentBlock("", "", 0, 0);
    }

    protected AbstractMarkupDocumentBuilder.Block computeHeading(int level, Attributes attributes) {
        return new ContentBlock(String.valueOf(this.computePrefix('#', level)) + " ", "", 1, 2);
    }

    public void characters(String text) {
        text = this.escapeAmpersand(text);
        this.assertOpenBlock();
        try {
            this.currentBlock.write(text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String escapeAmpersand(String text) {
        return text.replace("&", "&amp;");
    }

    public void entityReference(String entity) {
        this.assertOpenBlock();
        String literal = this.entityToLiteral.get(entity);
        if (literal == null) {
            literal = "&" + entity + ";";
        }
        try {
            this.currentBlock.write(literal);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void image(Attributes attributes, String url) {
        this.assertOpenBlock();
        try {
            this.currentBlock.write(this.computeImage(attributes, url));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String computeImage(Attributes attributes, String url) {
        String altText = "";
        String title = "";
        if (attributes instanceof ImageAttributes) {
            ImageAttributes imageAttr = (ImageAttributes)attributes;
            altText = Strings.nullToEmpty((String)imageAttr.getAlt());
        }
        if (!Strings.isNullOrEmpty((String)attributes.getTitle())) {
            title = " \"" + attributes.getTitle() + '\"';
        }
        return "![" + altText + "](" + Strings.nullToEmpty((String)url) + title + ')';
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.assertOpenBlock();
        LinkAttributes linkAttr = new LinkAttributes();
        linkAttr.setTitle(attributes.getTitle());
        linkAttr.setHref(hrefOrHashName);
        this.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)linkAttr);
        this.characters(text);
        this.endSpan();
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.link(linkAttributes, href, this.computeImage(imageAttributes, imageUrl));
    }

    public void acronym(String text, String definition) {
        throw new UnsupportedOperationException();
    }

    public void lineBreak() {
        this.assertOpenBlock();
        try {
            if (this.currentBlock instanceof MarkdownBlock) {
                ((MarkdownBlock)this.currentBlock).lineBreak();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractMarkupDocumentBuilder.Block createImplicitParagraphBlock() {
        return new ImplicitParagraphBlock();
    }

    private class CodeSpan
    extends ContentBlock {
        private CodeSpan() {
            super("`", "`", 0, 0);
        }

        @Override
        protected void emitContent(String content) throws IOException {
            if (content.contains("`")) {
                this.prefix = "`` ";
                this.suffix = " ``";
            }
            super.emitContent(content);
        }
    }

    private class ContentBlock
    extends AbstractMarkupDocumentBuilder.NewlineDelimitedBlock
    implements MarkdownBlock {
        protected String prefix;
        protected String suffix;

        ContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix, int leadingNewlines, int trailingNewlines) {
            super((AbstractMarkupDocumentBuilder)MarkdownDocumentBuilder.this, blockType, leadingNewlines, trailingNewlines);
            this.prefix = prefix;
            this.suffix = suffix;
        }

        ContentBlock(String prefix, String suffix, int leadingNewlines, int trailingNewlines) {
            this(null, prefix, suffix, leadingNewlines, trailingNewlines);
        }

        public void write(int c) throws IOException {
            MarkdownDocumentBuilder.this.emitContent(c);
        }

        public void write(String s) throws IOException {
            MarkdownDocumentBuilder.this.emitContent(s);
        }

        @Override
        public void lineBreak() throws IOException {
            this.write("  \n");
        }

        public void open() throws IOException {
            super.open();
            MarkdownDocumentBuilder.this.pushWriter(new StringWriter());
        }

        public void close() throws IOException {
            Writer thisContent = MarkdownDocumentBuilder.this.popWriter();
            String content = thisContent.toString();
            if (content.length() > 0) {
                this.emitContent(content);
            }
            super.close();
        }

        protected void emitContent(String content) throws IOException {
            MarkdownDocumentBuilder.this.emitContent(this.prefix);
            MarkdownDocumentBuilder.this.emitContent(content);
            MarkdownDocumentBuilder.this.emitContent(this.suffix);
        }
    }

    private class ImplicitParagraphBlock
    extends ContentBlock {
        ImplicitParagraphBlock() {
            super(DocumentBuilder.BlockType.PARAGRAPH, "", "", 2, 2);
        }

        protected boolean isImplicitBlock() {
            return true;
        }
    }

    private class LinkBlock
    extends ContentBlock {
        private final LinkAttributes attributes;

        LinkBlock(LinkAttributes attributes) {
            super("", "", 0, 0);
            this.attributes = attributes;
        }

        @Override
        protected void emitContent(String content) throws IOException {
            MarkdownDocumentBuilder.this.emitContent(91);
            MarkdownDocumentBuilder.this.emitContent(content);
            MarkdownDocumentBuilder.this.emitContent(93);
            MarkdownDocumentBuilder.this.emitContent(40);
            MarkdownDocumentBuilder.this.emitContent(this.attributes.getHref());
            if (!Strings.isNullOrEmpty((String)this.attributes.getTitle())) {
                MarkdownDocumentBuilder.this.emitContent(" \"");
                MarkdownDocumentBuilder.this.emitContent(this.attributes.getTitle());
                MarkdownDocumentBuilder.this.emitContent(34);
            }
            MarkdownDocumentBuilder.this.emitContent(41);
        }
    }

    private class ListBlock
    extends ContentBlock {
        private int count;

        ListBlock(DocumentBuilder.BlockType blockType, int leadingNewlines) {
            super(blockType, "", "", leadingNewlines, 1);
            this.count = 0;
        }

        @Override
        protected void emitContent(String content) throws IOException {
            MarkdownDocumentBuilder.this.emitContent(this.prefix);
            MarkdownDocumentBuilder.this.emitContent(content);
            if (!content.endsWith("\n\n")) {
                MarkdownDocumentBuilder.this.emitContent(this.suffix);
            }
        }

        protected void addListItem(ListItemBlock item) {
            Preconditions.checkNotNull((Object)item);
            ++this.count;
        }

        protected int getCount() {
            return this.count;
        }
    }

    private class ListItemBlock
    extends ContentBlock {
        private int count;

        private ListItemBlock(String prefix) {
            super(DocumentBuilder.BlockType.LIST_ITEM, prefix, "", 1, 1);
        }

        @Override
        public void open() throws IOException {
            super.open();
            if (this.getPreviousBlock() instanceof ListBlock) {
                ListBlock list = (ListBlock)this.getPreviousBlock();
                list.addListItem(this);
                this.count = list.getCount();
            }
        }

        @Override
        protected void emitContent(String content) throws IOException {
            if (this.getPreviousBlock().getBlockType() == DocumentBuilder.BlockType.NUMERIC_LIST) {
                this.prefix = String.valueOf(this.count) + ". ";
            }
            String indent = Strings.repeat((String)" ", (int)this.prefix.length());
            MarkdownDocumentBuilder.this.emitContent(this.prefix);
            Matcher matcher = PATTERN_LINE_BREAK.matcher(content);
            int lines = 0;
            while (matcher.find()) {
                String line = matcher.group(0);
                if (lines > 0 && !line.trim().isEmpty()) {
                    int indexOfFirstNonSpace = CharMatcher.isNot((char)' ').indexIn((CharSequence)line);
                    line = indexOfFirstNonSpace >= 4 ? String.valueOf(Strings.repeat((String)" ", (int)4)) + line : String.valueOf(indent) + line;
                }
                MarkdownDocumentBuilder.this.emitContent(line);
                ++lines;
            }
            if (!content.endsWith(this.suffix)) {
                MarkdownDocumentBuilder.this.emitContent(this.suffix);
            }
        }
    }

    private static interface MarkdownBlock {
        public void lineBreak() throws IOException;
    }

    private class PrefixedLineContentBlock
    extends ContentBlock {
        PrefixedLineContentBlock(DocumentBuilder.BlockType blockType, String prefix, String suffix, int leadingNewlines, int trailingNewlines) {
            super(blockType, prefix, suffix, leadingNewlines, trailingNewlines);
        }

        @Override
        protected void emitContent(String content) throws IOException {
            char lastChar = MarkdownDocumentBuilder.this.getLastChar();
            if (lastChar != '\n' && lastChar != '\r' && lastChar != '\u0000') {
                MarkdownDocumentBuilder.this.emitContent(10);
            }
            Matcher matcher = PATTERN_LINE_BREAK.matcher(content);
            while (matcher.find()) {
                String line = matcher.group(0);
                if (!line.trim().isEmpty()) {
                    MarkdownDocumentBuilder.this.emitContent(this.prefix);
                }
                MarkdownDocumentBuilder.this.emitContent(line);
            }
            if (!content.endsWith(this.suffix)) {
                MarkdownDocumentBuilder.this.emitContent(this.suffix);
            }
        }
    }
}

