/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ForeignKey;
import jakarta.persistence.PrimaryKeyJoinColumn;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPrimaryKeyJoinColumnImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.spi.ColumnDetails;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.ModelsContext;

public class PrimaryKeyJoinColumnJpaAnnotation
implements PrimaryKeyJoinColumn,
ColumnDetails,
ColumnDetails.Definable {
    private String name;
    private String referencedColumnName;
    private String columnDefinition;
    private String options;
    private ForeignKey foreignKey;

    public PrimaryKeyJoinColumnJpaAnnotation(ModelsContext modelContext) {
        this.name = "";
        this.referencedColumnName = "";
        this.columnDefinition = "";
        this.options = "";
        this.foreignKey = (ForeignKey)JpaAnnotations.FOREIGN_KEY.createUsage(modelContext);
    }

    public PrimaryKeyJoinColumnJpaAnnotation(PrimaryKeyJoinColumn annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.referencedColumnName = annotation.referencedColumnName();
        this.columnDefinition = annotation.columnDefinition();
        this.options = annotation.options();
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.PRIMARY_KEY_JOIN_COLUMN, "foreignKey", modelContext);
    }

    public PrimaryKeyJoinColumnJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.referencedColumnName = (String)attributeValues.get("referencedColumnName");
        this.columnDefinition = (String)attributeValues.get("columnDefinition");
        this.options = (String)attributeValues.get("options");
        this.foreignKey = (ForeignKey)attributeValues.get("foreignKey");
    }

    public Class<? extends Annotation> annotationType() {
        return PrimaryKeyJoinColumn.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String value) {
        this.name = value;
    }

    public String referencedColumnName() {
        return this.referencedColumnName;
    }

    public void referencedColumnName(String value) {
        this.referencedColumnName = value;
    }

    @Override
    public String columnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void columnDefinition(String value) {
        this.columnDefinition = value;
    }

    @Override
    public String options() {
        return this.options;
    }

    @Override
    public void options(String value) {
        this.options = value;
    }

    public ForeignKey foreignKey() {
        return this.foreignKey;
    }

    public void foreignKey(ForeignKey value) {
        this.foreignKey = value;
    }

    public void apply(JaxbPrimaryKeyJoinColumnImpl jaxbColumn, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbColumn.getName())) {
            this.name(jaxbColumn.getName());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getColumnDefinition())) {
            this.columnDefinition(jaxbColumn.getColumnDefinition());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getOptions())) {
            this.options(jaxbColumn.getOptions());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getReferencedColumnName())) {
            this.referencedColumnName(jaxbColumn.getReferencedColumnName());
        }
        if (jaxbColumn.getForeignKey() != null) {
            this.foreignKey(ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbColumn.getForeignKey(), xmlDocumentContext));
        }
    }
}

