/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ReadonlyAccessor;
import org.jruby.internal.runtime.UndefinedAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.func.TriConsumer;

public class GlobalVariables {
    private final Ruby runtime;
    private final Map<String, GlobalVariable> globalVariables = new ConcurrentHashMap<String, GlobalVariable>();
    private IRubyObject defaultSeparator;

    public GlobalVariables(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public void define(String name2, IAccessor accessor, GlobalVariable.Scope scope) {
        assert (name2 != null);
        assert (accessor != null);
        assert (name2.startsWith("$"));
        this.globalVariables.put(name2, new GlobalVariable(accessor, scope));
    }

    public void defineReadonly(String name2, IAccessor accessor, GlobalVariable.Scope scope) {
        assert (name2 != null);
        assert (accessor != null);
        assert (name2.startsWith("$"));
        this.globalVariables.put(name2, new GlobalVariable(new ReadonlyAccessor(name2, accessor), scope));
    }

    public boolean isDefined(String name2) {
        assert (name2 != null);
        assert (name2.startsWith("$"));
        GlobalVariable variable = this.globalVariables.get(name2);
        return variable != null && !(variable.getAccessor() instanceof UndefinedAccessor);
    }

    public void alias(String name2, String oldName) {
        assert (name2 != null);
        assert (oldName != null);
        assert (name2.startsWith("$"));
        assert (oldName.startsWith("$"));
        GlobalVariable oldVariable = this.createIfNotDefined(oldName);
        GlobalVariable variable = this.globalVariables.get(name2);
        if (variable != null && oldVariable != variable && variable.isTracing()) {
            throw RaiseException.from(this.runtime, this.runtime.getRuntimeError(), "can't alias in tracer");
        }
        if (variable != null) {
            variable.invalidate();
        }
        this.globalVariables.put(name2, oldVariable);
    }

    public IRubyObject get(String name2) {
        assert (name2 != null);
        assert (name2.startsWith("$"));
        GlobalVariable variable = this.globalVariables.get(name2);
        if (variable != null) {
            return variable.getAccessor().getValue();
        }
        if (this.runtime.isVerbose()) {
            this.runtime.getWarnings().warning(IRubyWarnings.ID.GLOBAL_NOT_INITIALIZED, "global variable '" + name2 + "' not initialized");
        }
        return this.runtime.getNil();
    }

    public GlobalVariable getVariable(String name2) {
        assert (name2 != null);
        assert (name2.startsWith("$"));
        return this.createIfNotDefined(name2);
    }

    public IRubyObject set(String name2, IRubyObject value2) {
        GlobalVariable variable = this.getVariable(name2);
        IRubyObject result2 = variable.getAccessor().setValue(value2);
        variable.trace(value2);
        variable.invalidate();
        return result2;
    }

    public IRubyObject clear(String name2) {
        return this.set(name2, this.runtime.getNil());
    }

    public void setTraceVar(String name2, RubyProc proc2) {
        this.getVariable(name2).addTrace(proc2);
    }

    public boolean untraceVar(String name2, IRubyObject command) {
        assert (name2 != null);
        assert (name2.startsWith("$"));
        if (this.isDefined(name2)) {
            GlobalVariable variable = this.globalVariables.get(name2);
            return variable.removeTrace(command);
        }
        return false;
    }

    public void untraceVar(String name2) {
        assert (name2 != null);
        assert (name2.startsWith("$"));
        if (this.isDefined(name2)) {
            GlobalVariable variable = this.globalVariables.get(name2);
            variable.removeTraces();
        }
    }

    public Set<String> getNames() {
        return this.globalVariables.keySet();
    }

    public <State> void eachName(ThreadContext context, State state2, TriConsumer<ThreadContext, State, String> consumer) {
        this.globalVariables.forEach((s2, g) -> consumer.accept(context, state2, (String)s2));
    }

    private GlobalVariable createIfNotDefined(String name2) {
        return this.globalVariables.computeIfAbsent(name2, n -> GlobalVariable.newUndefined(this.runtime, n));
    }

    public IRubyObject getDefaultSeparator() {
        return this.defaultSeparator;
    }

    public void setDefaultSeparator(IRubyObject defaultSeparator) {
        this.defaultSeparator = defaultSeparator;
    }

    public int size() {
        return this.globalVariables.size();
    }
}

