/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.gost;

import de.rub.nds.tlsattacker.core.crypto.gost.GOST28147Mac;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.engines.GOST28147Engine;
import org.bouncycastle.crypto.modes.GCFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.crypto.params.ParametersWithUKM;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class GOST28147WrapEngine
implements Wrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    private GOST28147Engine cipher = new GOST28147Engine();
    private GOST28147Mac mac = new GOST28147Mac();

    private static byte[] cryptoProDiversify(byte[] K, byte[] ukm, byte[] sBox) {
        for (int i = 0; i != 8; ++i) {
            int sOn = 0;
            int sOff = 0;
            for (int j = 0; j != 8; ++j) {
                int kj = Pack.littleEndianToInt((byte[])K, (int)(j * 4));
                if (GOST28147WrapEngine.bitSet(ukm[i], j)) {
                    sOn += kj;
                    continue;
                }
                sOff += kj;
            }
            byte[] s = new byte[8];
            Pack.intToLittleEndian((int)sOn, (byte[])s, (int)0);
            Pack.intToLittleEndian((int)sOff, (byte[])s, (int)4);
            GCFBBlockCipher c = new GCFBBlockCipher((BlockCipher)new GOST28147Engine());
            c.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new ParametersWithSBox((CipherParameters)new KeyParameter(K), sBox), s));
            c.processBlock(K, 0, K, 0);
            c.processBlock(K, 8, K, 8);
            c.processBlock(K, 16, K, 16);
            c.processBlock(K, 24, K, 24);
        }
        return K;
    }

    private static boolean bitSet(byte v, int bitNo) {
        return (v & 1 << bitNo) != 0;
    }

    public void init(boolean forWrapping, CipherParameters param) {
        KeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom pr = (ParametersWithRandom)param;
            param = pr.getParameters();
        }
        ParametersWithUKM pU = (ParametersWithUKM)param;
        byte[] sBox = null;
        if (pU.getParameters() instanceof ParametersWithSBox) {
            kParam = (KeyParameter)((ParametersWithSBox)pU.getParameters()).getParameters();
            sBox = ((ParametersWithSBox)pU.getParameters()).getSBox();
        } else {
            kParam = (KeyParameter)pU.getParameters();
        }
        kParam = new KeyParameter(GOST28147WrapEngine.cryptoProDiversify(kParam.getKey(), pU.getUKM(), sBox));
        Object cU = sBox != null ? new ParametersWithSBox((CipherParameters)kParam, sBox) : kParam;
        this.cipher.init(forWrapping, (CipherParameters)cU);
        this.mac.init((CipherParameters)new ParametersWithIV((CipherParameters)cU, pU.getUKM()));
    }

    public String getAlgorithmName() {
        return "GOST28147Wrap";
    }

    public byte[] wrap(byte[] input, int inOff, int inLen) {
        this.mac.update(input, inOff, inLen);
        byte[] wrappedKey = new byte[inLen + this.mac.getMacSize()];
        try {
            this.cipher.processBlock(input, inOff, wrappedKey, 0);
            this.cipher.processBlock(input, inOff + 8, wrappedKey, 8);
            this.cipher.processBlock(input, inOff + 16, wrappedKey, 16);
            this.cipher.processBlock(input, inOff + 24, wrappedKey, 24);
        }
        catch (Exception E) {
            LOGGER.warn("Could not wrap key. Continuing with partially wrapped key", (Throwable)E);
        }
        this.mac.doFinal(wrappedKey, inLen);
        return wrappedKey;
    }

    public byte[] unwrap(byte[] input, int inOff, int inLen) {
        byte[] decKey = new byte[inLen - this.mac.getMacSize()];
        this.cipher.processBlock(input, inOff, decKey, 0);
        this.cipher.processBlock(input, inOff + 8, decKey, 8);
        this.cipher.processBlock(input, inOff + 16, decKey, 16);
        this.cipher.processBlock(input, inOff + 24, decKey, 24);
        byte[] macResult = new byte[this.mac.getMacSize()];
        this.mac.update(decKey, 0, decKey.length);
        this.mac.doFinal(macResult, 0);
        byte[] macExpected = new byte[this.mac.getMacSize()];
        System.arraycopy(input, inOff + inLen - 4, macExpected, 0, this.mac.getMacSize());
        if (!Arrays.constantTimeAreEqual((byte[])macResult, (byte[])macExpected)) {
            throw new IllegalStateException("mac mismatch");
        }
        return decKey;
    }
}

