/*
*  RAL -- Rubrica Addressbook Library
*  file: error.h
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_ERROR_H
#define _R_ERROR_H

// TODO: rewrite better


typedef enum {
  NO_FILENAME = 0,
  FILE_EXIST, 
  FILE_NOT_EXIST, 
  FILE_NOT_OPENED,
  FILE_OPEN_SUCCESS,
  FILE_SAVE_SUCCESS,
  FILE_OPEN_FAIL,
  FILE_CSV_OPEN_FAIL,
  FILE_IMPORT_SUCCESS,
  NO_RUBRICA_DOC, 
  UNKNOWN_FILEFORMAT,
  UNKNOWN_VERSION,
  UNKNOWN_DOC,
  UNKNOWN_HEADER,
  UNKNOWN_FIELD,
  UNREADABLE_NODE,
  UNREADABLE_PROPERTY,
  UNREADABLE_CALENDAR,
  INVALID_DATE,
  KEY_NOT_VALID,

  PARSING_DOC,
  SELECT_FILE,
  IMPORT_FILE,
  BAD_MODULE,
  MODULE_IS_NULL,
  NO_ITEM_MODULE,
  NO_CARD_FORM,
  CSV_INVALID,
  FILENAME_INVALID,
  WRITING_XML,
  WRITING_FILE,
  OVERWRITING,
  DELETE_NOT_ALLOWED,

  /*    Group errors
   */
  GROUP_DELETED,
  ERROR_DELETING_GROUP,
  MODIFY_NOT_ALLOWED, 
  GROUP_MODIFIED,
  ERROR_MODIFYING_GROUP,
  UNKNOWN_MANAGER,
  UNKNOWN_GROUP,
  
  RUBRICA_VCARD_FILE_OPEN_SUCCESS,
  RUBRICA_VCARD_FILE_OPEN_FAIL,
  RUBRICA_VCARD_FILE_IMPORT_SUCCESS,

  PLUGIN_ERROR,

  NO_ERROR, 
} RError;

#endif
