/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class ImageUtil {
    private ImageUtil() {
    }

    public static void flipImageVertically(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        Object object = null;
        Object object2 = null;
        for (int i = 0; i < bufferedImage.getHeight() / 2; ++i) {
            object = writableRaster.getDataElements(0, i, bufferedImage.getWidth(), 1, object);
            object2 = writableRaster.getDataElements(0, bufferedImage.getHeight() - i - 1, bufferedImage.getWidth(), 1, object2);
            writableRaster.setDataElements(0, i, bufferedImage.getWidth(), 1, object2);
            writableRaster.setDataElements(0, bufferedImage.getHeight() - i - 1, bufferedImage.getWidth(), 1, object);
        }
    }

    public static BufferedImage createCompatibleImage(int n, int n2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return graphicsConfiguration.createCompatibleImage(n, n2);
    }

    public static BufferedImage createThumbnail(BufferedImage bufferedImage, int n) {
        if (n > bufferedImage.getWidth()) {
            throw new IllegalArgumentException("Thumbnail width must be greater than image width");
        }
        if (n == bufferedImage.getWidth()) {
            return bufferedImage;
        }
        float f = (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        BufferedImage bufferedImage2 = bufferedImage;
        do {
            if ((n2 /= 2) < n) {
                n2 = n;
            }
            BufferedImage bufferedImage3 = ImageUtil.createCompatibleImage(n2, (int)((float)n2 / f));
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage2, 0, 0, bufferedImage3.getWidth(), bufferedImage3.getHeight(), null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        } while (n2 != n);
        return bufferedImage2;
    }
}

