/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.feed;

import java.io.IOException;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.PseudoPage;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.DefaultDocumentMetaNode;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.context.DocumentMetaNode;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.layouter.feed.InputFeedException;
import org.jfree.layouting.namespace.NamespaceCollection;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.util.AttributeMap;

public class DefaultInputFeed
implements InputFeed {
    public static final int DOCUMENT_STARTING = 0;
    public static final int META_EXPECTED = 1;
    public static final int META_PROCESSING = 2;
    public static final int META_NODE_START = 3;
    public static final int META_NODE_ATTRIBUTES = 4;
    public static final int ELEMENT_EXPECTED = 5;
    public static final int ELEMENT_STARTED = 6;
    public static final int ELEMENT_ATTRIBUTES = 7;
    public static final int ELEMENT_CONTENT = 8;
    public static final int DOCUMENT_FINISHED = 9;
    private static final String[] STATE_NAMES = new String[]{"DOCUMENT_STARTING", "META_EXPECTED", "META_PROCESSING", "META_NODE_START", "META_NODE_ATTRIBUTES", "ELEMENT_EXPECTED", "ELEMENT_STARTED", "ELEMENT_ATTRIBUTES", "ELEMENT_CONTENT", "DOCUMENT_FINISHED"};
    private static boolean[][] validStateTransitions = new boolean[10][];
    private boolean initialized;
    private int state;
    private LayoutProcess process;
    private DocumentMetaNode metaNode;
    private DocumentContext documentContext;
    private Normalizer normalizer;
    private boolean pagebreakEncountered;
    private int treeDepth;
    private AttributeMap currentAttributes;
    private String namespace;
    private String tagName;

    public DefaultInputFeed(LayoutProcess layoutProcess) {
        this(layoutProcess, true);
    }

    protected DefaultInputFeed(LayoutProcess layoutProcess, boolean bl) {
        this.process = layoutProcess;
        this.documentContext = layoutProcess.getDocumentContext();
        if (bl) {
            this.normalizer = layoutProcess.getOutputProcessor().createNormalizer(layoutProcess);
            this.state = 0;
        }
    }

    @Override
    public void resetPageBreakFlag() {
        this.pagebreakEncountered = false;
    }

    @Override
    public void handlePageBreakEncountered(CSSValue cSSValue, PseudoPage[] pseudoPageArray) throws NormalizationException {
        this.pagebreakEncountered = true;
        this.normalizer.handlePageBreak(cSSValue, pseudoPageArray);
    }

    @Override
    public boolean isPagebreakEncountered() {
        return this.pagebreakEncountered;
    }

    private int checkState(int n) {
        if (!validStateTransitions[this.state][n]) {
            throw new IllegalStateException("illegal transition from " + STATE_NAMES[this.state] + " to " + STATE_NAMES[n]);
        }
        int n2 = this.state;
        this.state = n;
        return n2;
    }

    @Override
    public final void startDocument() {
        this.checkState(1);
        this.performStartDocument();
    }

    protected void performStartDocument() {
    }

    @Override
    public final void startMetaInfo() {
        this.checkState(2);
        this.performStartMetaInfo();
    }

    protected void performStartMetaInfo() {
    }

    @Override
    public final void addDocumentAttribute(String string, Object object) {
        this.checkState(2);
        this.performAddDocumentAttribute(string, object);
    }

    protected void performAddDocumentAttribute(String string, Object object) {
        this.documentContext.setMetaAttribute(string, object);
    }

    @Override
    public void startMetaNode() {
        this.checkState(3);
        this.performStartMetaNode();
    }

    protected void performStartMetaNode() {
        this.metaNode = new DefaultDocumentMetaNode();
        this.documentContext.addMetaNode(this.metaNode);
    }

    @Override
    public final void setMetaNodeAttribute(String string, Object object) {
        this.checkState(4);
        this.performSetMetaNodeAttribute(string, object);
    }

    protected void performSetMetaNodeAttribute(String string, Object object) {
        this.metaNode.setMetaAttribute(string, object);
    }

    @Override
    public void endMetaNode() {
        this.checkState(2);
        this.performEndMetaNode();
    }

    protected void performEndMetaNode() {
        this.metaNode = null;
    }

    @Override
    public final void endMetaInfo() throws InputFeedException {
        this.checkState(5);
        this.performEndMetaInfo();
    }

    @Override
    public NamespaceCollection getNamespaceCollection() {
        if (!this.initialized) {
            throw new IllegalStateException("Not yet!");
        }
        return this.documentContext.getNamespaces();
    }

    protected void performEndMetaInfo() throws InputFeedException {
        try {
            this.initializeDocument();
        }
        catch (Exception exception) {
            throw new InputFeedException("Failed to normalize element", exception);
        }
    }

    @Override
    public final void startElement(String string, String string2) throws InputFeedException {
        int n = this.checkState(6);
        if (n == 1 || n == 5) {
            try {
                this.initializeDocument();
            }
            catch (Exception exception) {
                throw new InputFeedException("Failed to normalize element", exception);
            }
        }
        if (n == 7 || n == 6) {
            try {
                this.getNormalizer().startElement(this.namespace, this.tagName, this.currentAttributes);
                this.currentAttributes = null;
            }
            catch (NormalizationException normalizationException) {
                throw new InputFeedException("Failed to normalize element", (Exception)((Object)normalizationException));
            }
            catch (IOException iOException) {
                throw new InputFeedException("IOError: Failed to normalize element", iOException);
            }
        }
        this.performStartElement(string, string2);
    }

    private void initializeDocument() throws IOException, NormalizationException {
        if (this.initialized) {
            return;
        }
        this.documentContext.initialize();
        this.getNormalizer().startDocument();
        this.initialized = true;
    }

    protected void performStartElement(String string, String string2) {
        this.namespace = string;
        this.tagName = string2;
        this.currentAttributes = new AttributeMap();
    }

    @Override
    public final void setAttribute(String string, String string2, Object object) {
        this.checkState(7);
        this.performSetAttribute(string, string2, object);
    }

    protected void performSetAttribute(String string, String string2, Object object) {
        this.currentAttributes.setAttribute(string, string2, object);
    }

    @Override
    public final void addContent(String string) throws InputFeedException {
        try {
            int n = this.checkState(8);
            if (n == 7 || n == 6) {
                this.getNormalizer().startElement(this.namespace, this.tagName, this.currentAttributes);
                this.currentAttributes = null;
            } else if (n == 5 || n == 1) {
                this.initializeDocument();
            }
            this.performAddContent(string);
        }
        catch (NormalizationException normalizationException) {
            throw new InputFeedException("Failed to normalize element", (Exception)((Object)normalizationException));
        }
        catch (IOException iOException) {
            throw new InputFeedException("Failed to normalize element", iOException);
        }
    }

    protected void performAddContent(String string) throws InputFeedException, IOException, NormalizationException {
        this.getNormalizer().addText(string);
    }

    @Override
    public final void endElement() throws InputFeedException {
        try {
            int n = this.checkState(5);
            if (n == 7 || n == 6) {
                this.getNormalizer().startElement(this.namespace, this.tagName, this.currentAttributes);
                this.currentAttributes = null;
            }
            this.performEndElement();
        }
        catch (NormalizationException normalizationException) {
            throw new InputFeedException("Failed to normalize element", (Exception)((Object)normalizationException));
        }
        catch (IOException iOException) {
            throw new InputFeedException("Failed to normalize element", iOException);
        }
    }

    protected void performEndElement() throws IOException, NormalizationException {
        this.namespace = null;
        this.tagName = null;
        this.currentAttributes = null;
        this.getNormalizer().endElement();
    }

    @Override
    public final void endDocument() throws InputFeedException {
        this.checkState(9);
        try {
            this.performEndDocument();
        }
        catch (NormalizationException normalizationException) {
            throw new InputFeedException("Failed to normalize element", (Exception)((Object)normalizationException));
        }
        catch (IOException iOException) {
            throw new InputFeedException("Failed to normalize element", iOException);
        }
    }

    protected void performEndDocument() throws IOException, NormalizationException {
        this.getNormalizer().endDocument();
    }

    protected LayoutProcess getProcess() {
        return this.process;
    }

    protected int getState() {
        return this.state;
    }

    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    @Override
    public State saveState() throws StateException {
        DefaultInputFeedState defaultInputFeedState = new DefaultInputFeedState();
        defaultInputFeedState.setTreeDepth(this.treeDepth);
        defaultInputFeedState.setCurrentAttributes(this.currentAttributes);
        defaultInputFeedState.setNamespace(this.namespace);
        defaultInputFeedState.setTagName(this.tagName);
        defaultInputFeedState.setInitialized(this.initialized);
        defaultInputFeedState.setMetaNode(this.metaNode);
        defaultInputFeedState.setNormalizerState(this.normalizer.saveState());
        defaultInputFeedState.setState(this.state);
        defaultInputFeedState.setPagebreakEncountered(this.pagebreakEncountered);
        return defaultInputFeedState;
    }

    @Override
    public Normalizer getCurrentNormalizer() {
        return this.normalizer;
    }

    static {
        DefaultInputFeed.validStateTransitions[0] = new boolean[]{false, true, false, false, false, false, false, false, false, false, false};
        DefaultInputFeed.validStateTransitions[1] = new boolean[]{false, false, true, false, false, false, true, false, false, false};
        DefaultInputFeed.validStateTransitions[2] = new boolean[]{false, false, true, true, false, true, false, false, false, false, false};
        DefaultInputFeed.validStateTransitions[3] = new boolean[]{false, false, false, false, true, false, false, false, false, false};
        DefaultInputFeed.validStateTransitions[4] = new boolean[]{false, false, true, false, true, false, false, false, false, false};
        DefaultInputFeed.validStateTransitions[5] = new boolean[]{false, false, false, false, false, true, true, false, true, true};
        DefaultInputFeed.validStateTransitions[6] = new boolean[]{false, false, false, false, false, true, true, true, true, true};
        DefaultInputFeed.validStateTransitions[7] = new boolean[]{false, false, false, false, false, true, true, true, true, true};
        DefaultInputFeed.validStateTransitions[8] = new boolean[]{false, false, false, false, false, true, true, false, true, true};
        DefaultInputFeed.validStateTransitions[9] = new boolean[]{false, false, false, false, false, false, false, false, false, false};
    }

    private static class DefaultInputFeedState
    implements State {
        private boolean initialized;
        private int state;
        private DocumentMetaNode metaNode;
        private State normalizerState;
        private boolean pagebreakEncountered;
        private int treeDepth;
        private AttributeMap currentAttributes;
        private String namespace;
        private String tagName;

        private DefaultInputFeedState() {
        }

        public int getTreeDepth() {
            return this.treeDepth;
        }

        public void setTreeDepth(int n) {
            this.treeDepth = n;
        }

        public AttributeMap getCurrentAttributes() {
            return this.currentAttributes;
        }

        public void setCurrentAttributes(AttributeMap attributeMap) {
            this.currentAttributes = attributeMap;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String string) {
            this.namespace = string;
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String string) {
            this.tagName = string;
        }

        public boolean isPagebreakEncountered() {
            return this.pagebreakEncountered;
        }

        public void setPagebreakEncountered(boolean bl) {
            this.pagebreakEncountered = bl;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public void setInitialized(boolean bl) {
            this.initialized = bl;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int n) {
            this.state = n;
        }

        public DocumentMetaNode getMetaNode() {
            return this.metaNode;
        }

        public void setMetaNode(DocumentMetaNode documentMetaNode) {
            this.metaNode = documentMetaNode;
        }

        public State getNormalizerState() {
            return this.normalizerState;
        }

        public void setNormalizerState(State state) {
            this.normalizerState = state;
        }

        @Override
        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            DefaultInputFeed defaultInputFeed = new DefaultInputFeed(layoutProcess, false);
            defaultInputFeed.initialized = this.initialized;
            defaultInputFeed.state = this.state;
            defaultInputFeed.metaNode = this.metaNode;
            defaultInputFeed.normalizer = (Normalizer)this.normalizerState.restore(layoutProcess);
            defaultInputFeed.pagebreakEncountered = this.pagebreakEncountered;
            defaultInputFeed.treeDepth = this.treeDepth;
            defaultInputFeed.currentAttributes = this.currentAttributes;
            defaultInputFeed.namespace = this.namespace;
            defaultInputFeed.tagName = this.tagName;
            return defaultInputFeed;
        }
    }
}

