/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Point;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.view.component.HyperlinkPage;

public class LogPage
extends HyperlinkPage
implements UriGettable,
IndexesChangeListener {
    protected API api;
    protected URI uri;
    protected Collection<Future<Indexes>> collectionOfFutureIndexes = Collections.emptyList();

    public LogPage(API api, URI uri, String content) {
        this.api = api;
        this.uri = uri;
        int index = 0;
        int eol = content.indexOf(10);
        while (eol != -1) {
            this.parseLine(content, index, eol);
            index = eol + 1;
            eol = content.indexOf(10, index);
        }
        this.parseLine(content, index, content.length());
        this.setText(content);
    }

    protected void parseLine(String content, int index, int eol) {
        int leftParenthesisIndex;
        int start = content.indexOf("at ", index);
        if (start != -1 && start < eol && (leftParenthesisIndex = content.indexOf(40, start)) != -1 && leftParenthesisIndex < eol) {
            this.addHyperlink(new LogHyperlinkData(start + 3, leftParenthesisIndex));
        }
    }

    @Override
    protected boolean isHyperlinkEnabled(HyperlinkPage.HyperlinkData hyperlinkData) {
        return ((LogHyperlinkData)hyperlinkData).enabled;
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkPage.HyperlinkData hyperlinkData) {
        block5: {
            LogHyperlinkData logHyperlinkData = (LogHyperlinkData)hyperlinkData;
            if (logHyperlinkData.enabled) {
                try {
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel(new Point(x - location.x, y - location.y));
                    this.api.addURI(new URI(this.uri.getScheme(), this.uri.getAuthority(), this.uri.getPath(), "position=" + offset, null));
                    String text = this.getText();
                    String typeAndMethodNames = text.substring(hyperlinkData.startPosition, hyperlinkData.endPosition);
                    int lastDotIndex = typeAndMethodNames.lastIndexOf(46);
                    String methodName = typeAndMethodNames.substring(lastDotIndex + 1);
                    String internalTypeName = typeAndMethodNames.substring(0, lastDotIndex).replace('.', '/');
                    List<Container.Entry> entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, internalTypeName);
                    int leftParenthesisIndex = hyperlinkData.endPosition + 1;
                    int rightParenthesisIndex = text.indexOf(41, leftParenthesisIndex);
                    String lineNumberOrNativeMethodFlag = text.substring(leftParenthesisIndex, rightParenthesisIndex);
                    if (lineNumberOrNativeMethodFlag.equals("Native Method")) {
                        lastDotIndex = internalTypeName.lastIndexOf(47);
                        String shortTypeName = internalTypeName.substring(lastDotIndex + 1);
                        this.api.openURI(x, y, entries, null, shortTypeName + '-' + methodName + "-(*)?");
                    } else {
                        int colonIndex = lineNumberOrNativeMethodFlag.indexOf(58);
                        String lineNumber = lineNumberOrNativeMethodFlag.substring(colonIndex + 1);
                        this.api.openURI(x, y, entries, "lineNumber=" + lineNumber, null);
                    }
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block5;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getFileName() {
        String path = this.uri.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        String text = this.getText();
        for (Map.Entry entry : this.hyperlinks.entrySet()) {
            int lastDotIndex;
            LogHyperlinkData entryData = (LogHyperlinkData)entry.getValue();
            String typeAndMethodNames = text.substring(entryData.startPosition, entryData.endPosition);
            String internalTypeName = typeAndMethodNames.substring(0, lastDotIndex = typeAndMethodNames.lastIndexOf(46)).replace('.', '/');
            boolean enabled = IndexesUtil.containsInternalTypeName(collectionOfFutureIndexes, internalTypeName);
            if (entryData.enabled == enabled) continue;
            entryData.enabled = enabled;
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }

    public static class LogHyperlinkData
    extends HyperlinkPage.HyperlinkData {
        public boolean enabled = false;

        public LogHyperlinkData(int startPosition, int endPosition) {
            super(startPosition, endPosition);
        }
    }
}

