/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrArithBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.BridgesConstruction;
import org.jetbrains.kotlin.ir.backend.js.lower.InlineClassArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0014J0\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001c*\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0&H\u0002J2\u0010'\u001a\u00020\"*\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010(\u001a\u00020$2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0&H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\t0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsBridgesConstruction;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BridgesConstruction;", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "context", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "calculator", "Lorg/jetbrains/kotlin/ir/backend/js/ir/JsIrArithBuilder;", "jsArguments", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "jsArrayGet", "jsArrayLength", "jsArrayLike2Array", "jsSliceArrayLikeFromIndex", "jsSliceArrayLikeFromIndexToIndex", "primitiveArrays", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "primitiveToLiteralConstructor", "getFunctionSignature", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getBridgeOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "bridge", "extractValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "blockBodyBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "irFunction", "createVarsForTrailingParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "numberOfTrailingParameters", "", "firstTrailingParameterIndexVar", "Lkotlin/Lazy;", "emitCopyVarargToArray", "varargIndex", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsBridgesConstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsBridgesConstruction.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsBridgesConstruction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n1567#2:159\n1598#2,4:160\n1872#2,3:164\n*S KotlinDebug\n*F\n+ 1 JsBridgesConstruction.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsBridgesConstruction\n*L\n103#1:159\n103#1:160,4\n138#1:164,3\n*E\n"})
public final class JsBridgesConstruction
extends BridgesConstruction<JsIrBackendContext> {
    @NotNull
    private final JsIrArithBuilder calculator;
    @NotNull
    private final IrSimpleFunctionSymbol jsArguments;
    @NotNull
    private final IrSimpleFunctionSymbol jsArrayGet;
    @NotNull
    private final IrSimpleFunctionSymbol jsArrayLength;
    @NotNull
    private final IrSimpleFunctionSymbol jsArrayLike2Array;
    @NotNull
    private final IrSimpleFunctionSymbol jsSliceArrayLikeFromIndex;
    @NotNull
    private final IrSimpleFunctionSymbol jsSliceArrayLikeFromIndexToIndex;
    @NotNull
    private final Map<IrClassSymbol, PrimitiveType> primitiveArrays;
    @NotNull
    private final Map<PrimitiveType, IrSimpleFunctionSymbol> primitiveToLiteralConstructor;

    public JsBridgesConstruction(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super((JsCommonBackendContext)context);
        this.calculator = new JsIrArithBuilder(context);
        this.jsArguments = context.getIntrinsics().getJsArguments();
        this.jsArrayGet = context.getIntrinsics().getJsArrayGet();
        this.jsArrayLength = context.getIntrinsics().getJsArrayLength();
        this.jsArrayLike2Array = context.getIntrinsics().getJsArrayLike2Array();
        this.jsSliceArrayLikeFromIndex = context.getIntrinsics().getJsSliceArrayLikeFromIndex();
        this.jsSliceArrayLikeFromIndexToIndex = context.getIntrinsics().getJsSliceArrayLikeFromIndexToIndex();
        this.primitiveArrays = context.getIntrinsics().getPrimitiveArrays();
        this.primitiveToLiteralConstructor = context.getIntrinsics().getPrimitiveToLiteralConstructor();
    }

    @Override
    @NotNull
    public String getFunctionSignature(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return NameTablesKt.jsFunctionSignature(function2, (JsIrBackendContext)this.getContext());
    }

    @Override
    @NotNull
    public IrDeclarationOrigin getBridgeOrigin(@NotNull IrSimpleFunction bridge) {
        Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
        return MiscKt.hasStableJsName(bridge, (JsIrBackendContext)this.getContext()) ? (IrDeclarationOrigin)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITH_STABLE_NAME() : (bridge.getCorrespondingPropertySymbol() != null ? (IrDeclarationOrigin)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_PROPERTY_ACCESSOR() : (IrDeclarationOrigin)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITHOUT_STABLE_NAME());
    }

    @Override
    @NotNull
    protected List<IrValueDeclaration> extractValueParameters(@NotNull IrBlockBodyBuilder blockBodyBuilder, @NotNull IrSimpleFunction irFunction, @NotNull IrSimpleFunction bridge) {
        IrCall irCall;
        Intrinsics.checkNotNullParameter((Object)blockBodyBuilder, (String)"blockBodyBuilder");
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
        if (!IrUtilsKt.isEffectivelyExternal(bridge)) {
            return super.extractValueParameters(blockBodyBuilder, irFunction, bridge);
        }
        int varargIndex = JsAstUtilsKt.varargParameterIndex(bridge);
        if (varargIndex == -1) {
            return super.extractValueParameters(blockBodyBuilder, irFunction, bridge);
        }
        IrBlockBodyBuilder $this$extractValueParameters_u24lambda_u242 = blockBodyBuilder;
        boolean bl = false;
        int numberOfTrailingParameters = bridge.getValueParameters().size() - (varargIndex + 1);
        IrCall $this$extractValueParameters_u24lambda_u242_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$extractValueParameters_u24lambda_u242, this.jsArrayLength);
        boolean bl2 = false;
        $this$extractValueParameters_u24lambda_u242_u24lambda_u240.putValueArgument(0, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$extractValueParameters_u24lambda_u242, this.jsArguments));
        $this$extractValueParameters_u24lambda_u242_u24lambda_u240.setType($this$extractValueParameters_u24lambda_u242.getContext().getIrBuiltIns().getIntType());
        IrCall getTotalNumberOfArguments = irCall;
        Lazy firstTrailingParameterIndexVar = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> JsBridgesConstruction.extractValueParameters$lambda$2$lambda$1($this$extractValueParameters_u24lambda_u242, numberOfTrailingParameters, getTotalNumberOfArguments, this));
        IrVariable varargArrayVar = this.emitCopyVarargToArray($this$extractValueParameters_u24lambda_u242, bridge, varargIndex, numberOfTrailingParameters, (Lazy<? extends IrVariable>)firstTrailingParameterIndexVar);
        List<IrVariable> trailingParametersVars = this.createVarsForTrailingParameters($this$extractValueParameters_u24lambda_u242, bridge, numberOfTrailingParameters, (Lazy<? extends IrVariable>)firstTrailingParameterIndexVar);
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)irFunction.getValueParameters(), (Object)varargArrayVar), (Iterable)trailingParametersVars);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrVariable> createVarsForTrailingParameters(IrBlockBodyBuilder $this$createVarsForTrailingParameters, IrSimpleFunction bridge, int numberOfTrailingParameters, Lazy<? extends IrVariable> firstTrailingParameterIndexVar) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = CollectionsKt.takeLast(bridge.getValueParameters(), (int)numberOfTrailingParameters);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void trailingParameter;
            void $this$createVarsForTrailingParameters_u24lambda_u244_u24lambda_u243;
            IrCall irCall;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrExpression parameterIndex = index == false ? (IrExpression)ExpressionHelpersKt.irGet($this$createVarsForTrailingParameters, (IrValueDeclaration)firstTrailingParameterIndexVar.getValue()) : this.calculator.add(ExpressionHelpersKt.irGet($this$createVarsForTrailingParameters, (IrValueDeclaration)firstTrailingParameterIndexVar.getValue()), ExpressionHelpersKt.irInt$default($this$createVarsForTrailingParameters, (int)index, null, 2, null));
            IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createVarsForTrailingParameters, this.jsArrayGet);
            IrStatementsBuilder irStatementsBuilder = $this$createVarsForTrailingParameters;
            boolean bl2 = false;
            $this$createVarsForTrailingParameters_u24lambda_u244_u24lambda_u243.putValueArgument(0, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createVarsForTrailingParameters, this.jsArguments));
            $this$createVarsForTrailingParameters_u24lambda_u244_u24lambda_u243.putValueArgument(1, parameterIndex);
            collection.add(IrBuilderKt.createTmpVariable$default(irStatementsBuilder, (IrExpression)irCall, trailingParameter.getName().asString(), false, null, trailingParameter.getType(), 12, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrVariable emitCopyVarargToArray(IrBlockBodyBuilder $this$emitCopyVarargToArray, IrSimpleFunction bridge, int varargIndex, int numberOfTrailingParameters, Lazy<? extends IrVariable> firstTrailingParameterIndexVar) {
        IrExpression irExpression;
        IrCall irCall;
        IrValueParameter varargElement = bridge.getValueParameters().get(varargIndex);
        Object[] objectArray = new IrExpression[]{ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$emitCopyVarargToArray, this.jsArguments)};
        List sliceIntrinsicArgs = CollectionsKt.mutableListOf((Object[])objectArray);
        IrSimpleFunctionSymbol sliceIntrinsic = this.jsArrayLike2Array;
        if (varargIndex != 0 || numberOfTrailingParameters > 0) {
            sliceIntrinsicArgs.add(ExpressionHelpersKt.irInt$default($this$emitCopyVarargToArray, varargIndex, null, 2, null));
            sliceIntrinsic = this.jsSliceArrayLikeFromIndex;
        }
        if (numberOfTrailingParameters > 0) {
            sliceIntrinsicArgs.add(ExpressionHelpersKt.irGet($this$emitCopyVarargToArray, (IrValueDeclaration)firstTrailingParameterIndexVar.getValue()));
            sliceIntrinsic = this.jsSliceArrayLikeFromIndexToIndex;
        }
        IrCall $this$emitCopyVarargToArray_u24lambda_u245 = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$emitCopyVarargToArray, sliceIntrinsic);
        boolean bl = false;
        IrType irType = varargElement.getVarargElementType();
        Intrinsics.checkNotNull((Object)irType);
        $this$emitCopyVarargToArray_u24lambda_u245.putTypeArgument(0, irType);
        Iterable $this$forEachIndexed$iv = sliceIntrinsicArgs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void p1;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrExpression irExpression2 = (IrExpression)item$iv;
            int p0 = n;
            boolean bl2 = false;
            $this$emitCopyVarargToArray_u24lambda_u245.putValueArgument(p0, (IrExpression)p1);
        }
        IrCall arrayExpr = irCall;
        boolean bl3 = false;
        JsIrBackendContext jsIrBackendContext = (JsIrBackendContext)this.getContext();
        IrType irType2 = varargElement.getVarargElementType();
        Intrinsics.checkNotNull((Object)irType2);
        InlineClassArrayInfo arrayInfo = new InlineClassArrayInfo(jsIrBackendContext, irType2, varargElement.getType());
        PrimitiveType primitiveType = this.primitiveArrays.get(IrTypesKt.getClassifierOrNull(arrayInfo.getPrimitiveArrayType()));
        if (primitiveType != null) {
            void $this$emitCopyVarargToArray_u24lambda_u247_u24lambda_u246;
            IrCall irCall2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$emitCopyVarargToArray, (IrSimpleFunctionSymbol)MapsKt.getValue(this.primitiveToLiteralConstructor, (Object)((Object)primitiveType)));
            IrCall irCall3 = irCall2;
            InlineClassArrayInfo inlineClassArrayInfo = arrayInfo;
            boolean bl4 = false;
            $this$emitCopyVarargToArray_u24lambda_u247_u24lambda_u246.putValueArgument(0, arrayExpr);
            $this$emitCopyVarargToArray_u24lambda_u247_u24lambda_u246.setType(varargElement.getType());
            irExpression = inlineClassArrayInfo.boxArrayIfNeeded(irCall2);
        } else {
            irExpression = arrayExpr;
        }
        IrExpression varargCopiedAsArray = irExpression;
        return IrBuilderKt.createTmpVariable$default($this$emitCopyVarargToArray, varargCopiedAsArray, varargElement.getName().asString(), false, null, null, 28, null);
    }

    private static final IrVariable extractValueParameters$lambda$2$lambda$1(IrBlockBodyBuilder $this_run, int $numberOfTrailingParameters, IrCall $getTotalNumberOfArguments, JsBridgesConstruction this$0) {
        return ExpressionHelpersKt.irTemporary$default($this_run, $numberOfTrailingParameters == 0 ? (IrExpression)$getTotalNumberOfArguments : this$0.calculator.sub($getTotalNumberOfArguments, ExpressionHelpersKt.irInt$default($this_run, $numberOfTrailingParameters, null, 2, null)), "firstTrailingParameterIndex", null, false, null, 28, null);
    }
}

