untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46Nvh8XaO/WsHkxac+vyfSniMFEf2ellXO78Gz2AQPvpACCZKxFI9t9YGot0/aZPz49WjluLnf4j0Voh2AcFdEQ4=

OpenBSD 6.9 errata 004, May 21, 2021:

Insufficient validation of A-MSDUs and fragmented 802.11 frames could
be abused to inject arbitrary frames.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 004_net80211.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net80211/ieee80211_input.c
===================================================================
RCS file: /cvs/src/sys/net80211/ieee80211_input.c,v
retrieving revision 1.232
diff -u -p -r1.232 ieee80211_input.c
--- sys/net80211/ieee80211_input.c	26 Mar 2021 10:18:55 -0000	1.232
+++ sys/net80211/ieee80211_input.c	19 May 2021 06:42:54 -0000
@@ -76,6 +76,8 @@ void	ieee80211_input_ba_seq(struct ieee8
 struct	mbuf *ieee80211_align_mbuf(struct mbuf *);
 void	ieee80211_decap(struct ieee80211com *, struct mbuf *,
 	    struct ieee80211_node *, int, struct mbuf_list *);
+int	ieee80211_amsdu_decap_validate(struct ieee80211com *, struct mbuf *,
+	    struct ieee80211_node *);
 void	ieee80211_amsdu_decap(struct ieee80211com *, struct mbuf *,
 	    struct ieee80211_node *, int, struct mbuf_list *);
 void	ieee80211_enqueue_data(struct ieee80211com *, struct mbuf *,
@@ -372,6 +374,20 @@ ieee80211_inputm(struct ifnet *ifp, stru
 		}
 	}
 
+	/*
+	 * We do not yet support fragments. Drop any fragmented packets.
+	 * Counter-measure against attacks where an arbitrary packet is
+	 * injected via a fragment with attacker-controlled content.
+	 * See https://papers.mathyvanhoef.com/usenix2021.pdf
+	 * Section 6.8 "Treating fragments as full frames"
+	 */
+	if (ieee80211_has_seq(wh)) {
+		uint16_t rxseq = letoh16(*(const u_int16_t *)wh->i_seq);
+		if ((wh->i_fc[1] & IEEE80211_FC1_MORE_FRAG) ||
+		    (rxseq & IEEE80211_SEQ_FRAG_MASK))
+			goto err;
+	}
+
 	/* duplicate detection (see 9.2.9) */
 	if (ieee80211_has_seq(wh) &&
 	    ic->ic_state != IEEE80211_S_SCAN) {
@@ -1139,6 +1155,50 @@ ieee80211_decap(struct ieee80211com *ic,
 	ieee80211_enqueue_data(ic, m, ni, mcast, ml);
 }
 
+int
+ieee80211_amsdu_decap_validate(struct ieee80211com *ic, struct mbuf *m,
+    struct ieee80211_node *ni)
+{
+	struct ether_header *eh = mtod(m, struct ether_header *);
+	const uint8_t llc_hdr_mac[ETHER_ADDR_LEN] = {
+		/* MAC address matching the 802.2 LLC header. */
+		LLC_SNAP_LSAP, LLC_SNAP_LSAP, LLC_UI, 0, 0, 0
+	}; 
+
+	/*
+	 * We are sorry, but this particular MAC address cannot be used.
+	 * This mitigates an attack where a single 802.11 frame is interpreted
+	 * as an A-MSDU because of a forged AMSDU-present bit in the 802.11
+	 * QoS frame header: https://papers.mathyvanhoef.com/usenix2021.pdf
+	 * See Section 7.2, 'Countermeasures for the design flaws'
+	 */
+	if (ETHER_IS_EQ(eh->ether_dhost, llc_hdr_mac))
+		return 1;
+
+	switch (ic->ic_opmode) {
+#ifndef IEEE80211_STA_ONLY
+	case IEEE80211_M_HOSTAP:
+		/*
+		 * Subframes must use the source address of the node which
+		 * transmitted the A-MSDU. Prevents MAC spoofing.
+		 */
+		if (!ETHER_IS_EQ(ni->ni_macaddr, eh->ether_shost))
+			return 1;
+		break;
+#endif
+	case IEEE80211_M_STA:
+		/* Subframes must be addressed to me. */
+		if (!ETHER_IS_EQ(ic->ic_myaddr, eh->ether_dhost))
+			return 1;
+		break;
+	default:
+		/* Ignore MONITOR/IBSS modes for now. */
+		break;
+	}
+
+	return 0;
+}
+
 /*
  * Decapsulate an Aggregate MSDU (see 7.2.2.2).
  */
@@ -1151,6 +1211,7 @@ ieee80211_amsdu_decap(struct ieee80211co
 	struct llc *llc;
 	int len, pad, mcast;
 	struct ieee80211_frame *wh;
+	struct mbuf_list subframes = MBUF_LIST_INITIALIZER();
 
 	wh = mtod(m, struct ieee80211_frame *);
 	mcast = IEEE80211_IS_MULTICAST(wh->i_addr1);
@@ -1161,10 +1222,8 @@ ieee80211_amsdu_decap(struct ieee80211co
 	while (m->m_pkthdr.len >= ETHER_HDR_LEN + LLC_SNAPFRAMELEN) {
 		/* process an A-MSDU subframe */
 		m = m_pullup(m, ETHER_HDR_LEN + LLC_SNAPFRAMELEN);
-		if (m == NULL) {
-			ic->ic_stats.is_rx_decap++;
-			return;
-		}
+		if (m == NULL)
+			break;
 		eh = mtod(m, struct ether_header *);
 		/* examine 802.3 header */
 		len = ntohs(eh->ether_type);
@@ -1172,11 +1231,12 @@ ieee80211_amsdu_decap(struct ieee80211co
 			DPRINTF(("A-MSDU subframe too short (%d)\n", len));
 			/* stop processing A-MSDU subframes */
 			ic->ic_stats.is_rx_decap++;
+			ml_purge(&subframes);
 			m_freem(m);
 			return;
 		}
 		llc = (struct llc *)&eh[1];
-		/* examine 802.2 LLC header */
+		/* Examine the 802.2 LLC header after the A-MSDU header. */
 		if (llc->llc_dsap == LLC_SNAP_LSAP &&
 		    llc->llc_ssap == LLC_SNAP_LSAP &&
 		    llc->llc_control == LLC_UI &&
@@ -1196,6 +1256,7 @@ ieee80211_amsdu_decap(struct ieee80211co
 			/* stop processing A-MSDU subframes */
 			DPRINTF(("A-MSDU subframe too long (%d)\n", len));
 			ic->ic_stats.is_rx_decap++;
+			ml_purge(&subframes);
 			m_freem(m);
 			return;
 		}
@@ -1205,16 +1266,29 @@ ieee80211_amsdu_decap(struct ieee80211co
 		if (n == NULL) {
 			/* stop processing A-MSDU subframes */
 			ic->ic_stats.is_rx_decap++;
+			ml_purge(&subframes);
 			m_freem(m);
 			return;
 		}
-		ieee80211_enqueue_data(ic, m, ni, mcast, ml);
 
+		if (ieee80211_amsdu_decap_validate(ic, m, ni)) {
+			/* stop processing A-MSDU subframes */
+			ic->ic_stats.is_rx_decap++;
+			ml_purge(&subframes);
+			m_freem(m);
+			return;
+		}
+
+		ml_enqueue(&subframes, m);
+	
 		m = n;
 		/* remove padding */
 		pad = ((len + 3) & ~3) - len;
 		m_adj(m, pad);
 	}
+	
+	while ((n = ml_dequeue(&subframes)) != NULL)
+		ieee80211_enqueue_data(ic, n, ni, mcast, ml);
 
 	m_freem(m);
 }
