untrusted comment: signature from openbsd 5.7 base secret key
RWSvUZXnw9gUbzlqxwSdqP/pZmYC8V1nvdAZ9A5dNmHGczeQrT493IMx1ndKCIVOzolPKwXR5Ahft4HOAFg2WDxSTw8XSpjJggo=

OpenBSD 5.7 errata 20, Nov 9, 2015

Insufficient validation of RSN element group cipher values in 802.11
beacons and probe responses could result in system panics.

Apply by doing:
    signify -Vep /etc/signify/openbsd-57-base.pub -x 020_rsn.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/net80211/ieee80211_input.c
===================================================================
RCS file: /cvs/src/sys/net80211/ieee80211_input.c,v
retrieving revision 1.132
diff -u -p -r1.132 ieee80211_input.c
--- sys/net80211/ieee80211_input.c	9 Feb 2015 03:09:57 -0000	1.132
+++ sys/net80211/ieee80211_input.c	8 Nov 2015 12:04:42 -0000
@@ -1232,7 +1232,9 @@ ieee80211_parse_rsn_body(struct ieee8021
 	if (frm + 4 > efrm)
 		return 0;
 	rsn->rsn_groupcipher = ieee80211_parse_rsn_cipher(frm);
-	if (rsn->rsn_groupcipher == IEEE80211_CIPHER_USEGROUP)
+	if (rsn->rsn_groupcipher == IEEE80211_CIPHER_NONE ||
+	    rsn->rsn_groupcipher == IEEE80211_CIPHER_USEGROUP ||
+	    rsn->rsn_groupcipher == IEEE80211_CIPHER_BIP)
 		return IEEE80211_STATUS_BAD_GROUP_CIPHER;
 	frm += 4;
 
@@ -1296,6 +1298,8 @@ ieee80211_parse_rsn_body(struct ieee8021
 	if (frm + 4 > efrm)
 		return 0;
 	rsn->rsn_groupmgmtcipher = ieee80211_parse_rsn_cipher(frm);
+	if (rsn->rsn_groupmgmtcipher != IEEE80211_CIPHER_BIP)
+		return IEEE80211_STATUS_BAD_GROUP_CIPHER;
 
 	return IEEE80211_STATUS_SUCCESS;
 }
