/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ECDHClientKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskEcDhClientKeyExchangeSerializer
extends ECDHClientKeyExchangeSerializer<PskEcDhClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PskEcDhClientKeyExchangeMessage msg;

    public PskEcDhClientKeyExchangeSerializer(PskEcDhClientKeyExchangeMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing PSKECDHClientKeyExchangeMessage");
        this.writePSKIdentityLength(this.msg);
        this.writePSKIdentity(this.msg);
        super.serializeEcDhParams();
        return this.getAlreadySerialized();
    }

    private void writePSKIdentityLength(PskEcDhClientKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getIdentityLength().getValue(), 2);
        LOGGER.debug("SerializedPSKIdentityLength: " + ArrayConverter.bytesToInt((byte[])((byte[])msg.getIdentity().getValue())));
    }

    private void writePSKIdentity(PskEcDhClientKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getIdentity().getValue());
        LOGGER.debug("SerializedPSKIdentity: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getIdentity().getValue())));
    }
}

