/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.record;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.kafka.common.record.CompressionType;

public enum BrokerCompressionType {
    UNCOMPRESSED("uncompressed"){

        @Override
        public CompressionType targetCompressionType(CompressionType producerCompressionType) {
            return CompressionType.NONE;
        }
    }
    ,
    ZSTD("zstd"){

        @Override
        public CompressionType targetCompressionType(CompressionType producerCompressionType) {
            return CompressionType.ZSTD;
        }
    }
    ,
    LZ4("lz4"){

        @Override
        public CompressionType targetCompressionType(CompressionType producerCompressionType) {
            return CompressionType.LZ4;
        }
    }
    ,
    SNAPPY("snappy"){

        @Override
        public CompressionType targetCompressionType(CompressionType producerCompressionType) {
            return CompressionType.SNAPPY;
        }
    }
    ,
    GZIP("gzip"){

        @Override
        public CompressionType targetCompressionType(CompressionType producerCompressionType) {
            return CompressionType.GZIP;
        }
    }
    ,
    PRODUCER("producer"){

        @Override
        public CompressionType targetCompressionType(CompressionType producerCompressionType) {
            return producerCompressionType;
        }
    };

    private static final List<BrokerCompressionType> VALUES;
    public final String name;

    private BrokerCompressionType(String name) {
        this.name = name;
    }

    public abstract CompressionType targetCompressionType(CompressionType var1);

    public static List<String> names() {
        return VALUES.stream().map(v -> v.name).collect(Collectors.toList());
    }

    public static BrokerCompressionType forName(String n) {
        String name = n.toLowerCase(Locale.ROOT);
        return VALUES.stream().filter(v -> v.name.equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown broker compression type name: " + name));
    }

    static {
        VALUES = Arrays.asList(BrokerCompressionType.values());
    }
}

