/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class MotifScrollPaneUI
extends BasicScrollPaneUI {
    private static final Border vsbMarginBorderR = new EmptyBorder(0, 4, 0, 0);
    private static final Border vsbMarginBorderL = new EmptyBorder(0, 0, 0, 4);
    private static final Border hsbMarginBorder = new EmptyBorder(4, 0, 0, 0);
    private CompoundBorder vsbBorder;
    private CompoundBorder hsbBorder;
    private PropertyChangeListener propertyChangeHandler;

    @Override
    protected void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        this.propertyChangeHandler = this.createPropertyChangeHandler();
        jScrollPane.addPropertyChangeListener(this.propertyChangeHandler);
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        super.uninstallListeners(jComponent);
        jComponent.removePropertyChangeListener(this.propertyChangeHandler);
    }

    private PropertyChangeListener createPropertyChangeHandler() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JScrollPane jScrollPane;
                JScrollBar jScrollBar;
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("componentOrientation") && (jScrollBar = (jScrollPane = (JScrollPane)propertyChangeEvent.getSource()).getVerticalScrollBar()) != null && MotifScrollPaneUI.this.vsbBorder != null && jScrollBar.getBorder() == MotifScrollPaneUI.this.vsbBorder) {
                    if (MotifGraphicsUtils.isLeftToRight(jScrollPane)) {
                        MotifScrollPaneUI.this.vsbBorder = new CompoundBorder(vsbMarginBorderR, MotifScrollPaneUI.this.vsbBorder.getInsideBorder());
                    } else {
                        MotifScrollPaneUI.this.vsbBorder = new CompoundBorder(vsbMarginBorderL, MotifScrollPaneUI.this.vsbBorder.getInsideBorder());
                    }
                    jScrollBar.setBorder(MotifScrollPaneUI.this.vsbBorder);
                }
            }
        };
    }

    @Override
    protected void installDefaults(JScrollPane jScrollPane) {
        JScrollBar jScrollBar;
        super.installDefaults(jScrollPane);
        JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
        if (jScrollBar2 != null) {
            this.vsbBorder = MotifGraphicsUtils.isLeftToRight(jScrollPane) ? new CompoundBorder(vsbMarginBorderR, jScrollBar2.getBorder()) : new CompoundBorder(vsbMarginBorderL, jScrollBar2.getBorder());
            jScrollBar2.setBorder(this.vsbBorder);
        }
        if ((jScrollBar = jScrollPane.getHorizontalScrollBar()) != null) {
            this.hsbBorder = new CompoundBorder(hsbMarginBorder, jScrollBar.getBorder());
            jScrollBar.setBorder(this.hsbBorder);
        }
    }

    @Override
    protected void uninstallDefaults(JScrollPane jScrollPane) {
        JScrollBar jScrollBar;
        super.uninstallDefaults(jScrollPane);
        JScrollBar jScrollBar2 = this.scrollpane.getVerticalScrollBar();
        if (jScrollBar2 != null) {
            if (jScrollBar2.getBorder() == this.vsbBorder) {
                jScrollBar2.setBorder(null);
            }
            this.vsbBorder = null;
        }
        if ((jScrollBar = this.scrollpane.getHorizontalScrollBar()) != null) {
            if (jScrollBar.getBorder() == this.hsbBorder) {
                jScrollBar.setBorder(null);
            }
            this.hsbBorder = null;
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifScrollPaneUI();
    }
}

