"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

module.exports = {
  rootDir: "../",
  setupFiles: ["<rootDir>/test/polyfills.ts", "<rootDir>/test/setupTests.ts"],
  setupFilesAfterEnv: ["<rootDir>/test/setup.jest.ts"],
  setupFilesAfterEnv: ["<rootDir>/test/setup.jest.ts", "<rootDir>../../src/dev/jest/setup/monaco_mock.js"],
  roots: ["<rootDir>"],
  coverageDirectory: "./coverage",
  moduleNameMapper: {
    "\\.(css|less|scss)$": "<rootDir>/test/mocks/styleMock.ts",
    "^ui/(.*)": "<rootDir>/../../src/legacy/ui/public/$1/"
  },
  coverageReporters: ["lcov", "text", "cobertura"],
  testMatch: ["**/*.test.js", "**/*.test.jsx", "**/*.test.ts", "**/*.test.tsx"],
  collectCoverageFrom: ["**/*.ts", "**/*.tsx", "**/*.js", "**/*.jsx", "!**/models/**", "!**/node_modules/**", "!**/index.ts", "!<rootDir>/index.js", "!<rootDir>/public/app.js", "!<rootDir>/public/temporary/**", "!<rootDir>/babel.config.js", "!<rootDir>/test/**", "!<rootDir>/server/**", "!<rootDir>/coverage/**", "!<rootDir>/scripts/**", "!<rootDir>/build/**", "!<rootDir>/cypress/**", "!**/vendor/**", "!**/index.d.ts", "!**/lib/field/**",
  // There is a compile error in monaco-editor, ignore related components
  "!**/components/JSONDiffEditor/**"],
  clearMocks: true,
  testPathIgnorePatterns: ["<rootDir>/build/", "<rootDir>/node_modules/"],
  modulePathIgnorePatterns: ["indexManagementDashboards"],
  testEnvironment: "jsdom"
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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