/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.SynchronizationType;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import liquibase.GlobalConfiguration;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.ServerStartupError;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.connections.jpa.DefaultJpaConnectionProvider;
import org.keycloak.connections.jpa.HibernateStatsReporter;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProviderFactory;
import org.keycloak.connections.jpa.JpaKeycloakTransaction;
import org.keycloak.connections.jpa.support.EntityManagerProxy;
import org.keycloak.connections.jpa.updater.JpaUpdaterProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.migration.MigrationModelManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.dblock.DBLockManager;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.timer.TimerProvider;
import org.keycloak.transaction.JtaTransactionManagerLookup;

public class DefaultJpaConnectionProviderFactory
implements JpaConnectionProviderFactory,
ServerInfoAwareProviderFactory {
    private static final Logger logger = Logger.getLogger(DefaultJpaConnectionProviderFactory.class);
    private volatile EntityManagerFactory emf;
    private Config.Scope config;
    private Map<String, String> operationalInfo;
    private boolean jtaEnabled;
    private JtaTransactionManagerLookup jtaLookup;
    private KeycloakSessionFactory factory;

    public JpaConnectionProvider create(KeycloakSession session) {
        logger.trace((Object)"Create JpaConnectionProvider");
        this.lazyInit(session);
        return new DefaultJpaConnectionProvider(this.createEntityManager(session));
    }

    private EntityManager createEntityManager(KeycloakSession session) {
        EntityManager em;
        if (!this.jtaEnabled) {
            logger.trace((Object)"enlisting EntityManager in JpaKeycloakTransaction");
            em = this.emf.createEntityManager();
        } else {
            em = this.emf.createEntityManager(SynchronizationType.SYNCHRONIZED);
        }
        em = EntityManagerProxy.create((KeycloakSession)session, (EntityManager)em);
        if (!this.jtaEnabled) {
            session.getTransactionManager().enlist((KeycloakTransaction)new JpaKeycloakTransaction(em));
        }
        return em;
    }

    private void addSpecificNamedQueries(KeycloakSession session, Connection connection) {
        EntityManager em = null;
        try {
            em = this.createEntityManager(session);
            String dbKind = JpaUtils.getDatabaseType(connection.getMetaData().getDatabaseProductName());
            for (Map.Entry<Object, Object> query : JpaUtils.loadSpecificNamedQueries(dbKind.toLowerCase()).entrySet()) {
                String queryName = query.getKey().toString();
                String querySql = query.getValue().toString();
                JpaUtils.configureNamedQuery(queryName, querySql, em);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        finally {
            JpaUtils.closeEntityManager(em);
        }
    }

    public void close() {
        if (this.emf != null) {
            this.emf.close();
        }
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.factory = factory;
        this.checkJtaEnabled(factory);
    }

    protected void checkJtaEnabled(KeycloakSessionFactory factory) {
        this.jtaLookup = (JtaTransactionManagerLookup)factory.getProviderFactory(JtaTransactionManagerLookup.class);
        if (this.jtaLookup != null && this.jtaLookup.getTransactionManager() != null) {
            this.jtaEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.emf == null) {
            DefaultJpaConnectionProviderFactory defaultJpaConnectionProviderFactory = this;
            synchronized (defaultJpaConnectionProviderFactory) {
                if (this.emf == null) {
                    KeycloakModelUtils.suspendJtaTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), () -> {
                        logger.debugf("Initializing JPA connections%s", StackUtil.getShortStackTrace());
                        HashMap<String, Object> properties = new HashMap<String, Object>();
                        String unitName = "keycloak-default";
                        String dataSource = this.config.get("dataSource");
                        if (dataSource != null) {
                            if (this.config.getBoolean("jta", Boolean.valueOf(this.jtaEnabled)).booleanValue()) {
                                properties.put("jakarta.persistence.jtaDataSource", dataSource);
                            } else {
                                properties.put("jakarta.persistence.nonJtaDataSource", dataSource);
                            }
                        } else {
                            String password;
                            String url = this.config.get("url");
                            String driver = this.config.get("driver");
                            url = this.augmentJdbcUrl(driver, url);
                            properties.put("jakarta.persistence.jdbc.url", url);
                            properties.put("jakarta.persistence.jdbc.driver", driver);
                            String user = this.config.get("user");
                            if (user != null) {
                                properties.put("jakarta.persistence.jdbc.user", user);
                            }
                            if ((password = this.config.get("password")) != null) {
                                properties.put("jakarta.persistence.jdbc.password", password);
                            }
                        }
                        String schema = this.getSchema();
                        if (schema != null) {
                            properties.put("hibernate.default_schema", schema);
                        }
                        MigrationStrategy migrationStrategy = this.getMigrationStrategy();
                        boolean initializeEmpty = this.config.getBoolean("initializeEmpty", Boolean.valueOf(true));
                        File databaseUpdateFile = this.getDatabaseUpdateFile();
                        properties.put("hibernate.show_sql", this.config.getBoolean("showSql", Boolean.valueOf(false)));
                        properties.put("hibernate.format_sql", this.config.getBoolean("formatSql", Boolean.valueOf(true)));
                        Connection connection = this.getConnection();
                        try {
                            this.prepareOperationalInfo(connection);
                            String driverDialect = this.config.get("driverDialect");
                            if (driverDialect != null && !driverDialect.isBlank()) {
                                properties.put("hibernate.dialect", driverDialect);
                            }
                            this.migration(migrationStrategy, initializeEmpty, schema, databaseUpdateFile, connection, session);
                            int globalStatsInterval = this.config.getInt("globalStatsInterval", Integer.valueOf(-1));
                            if (globalStatsInterval != -1) {
                                properties.put("hibernate.generate_statistics", true);
                            }
                            logger.trace((Object)"Creating EntityManagerFactory");
                            logger.tracev("***** create EMF jtaEnabled {0} ", (Object)this.jtaEnabled);
                            if (this.jtaEnabled) {
                                properties.put("hibernate.transaction.jta.platform", new AbstractJtaPlatform(){

                                    protected TransactionManager locateTransactionManager() {
                                        return DefaultJpaConnectionProviderFactory.this.jtaLookup.getTransactionManager();
                                    }

                                    protected UserTransaction locateUserTransaction() {
                                        return null;
                                    }
                                });
                            }
                            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
                            if (properties.containsKey("hibernate.classLoaders")) {
                                classLoaders.addAll((Collection)properties.get("hibernate.classLoaders"));
                            }
                            classLoaders.add(this.getClass().getClassLoader());
                            properties.put("hibernate.classLoaders", classLoaders);
                            this.emf = JpaUtils.createEntityManagerFactory(session, unitName, properties, this.jtaEnabled);
                            this.addSpecificNamedQueries(session, connection);
                            logger.trace((Object)"EntityManagerFactory created");
                            if (globalStatsInterval != -1) {
                                this.startGlobalStats(session, globalStatsInterval);
                            }
                            logger.debug((Object)"Calling migrateModel");
                            this.migrateModel(session);
                        }
                        finally {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (SQLException e) {
                                    logger.warn((Object)"Can't close connection", (Throwable)e);
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    private File getDatabaseUpdateFile() {
        String databaseUpdateFile = this.config.get("migrationExport", "keycloak-database-update.sql");
        return new File(databaseUpdateFile);
    }

    protected void prepareOperationalInfo(Connection connection) {
        try {
            this.operationalInfo = new LinkedHashMap<String, String>();
            DatabaseMetaData md = connection.getMetaData();
            this.operationalInfo.put("databaseUrl", md.getURL());
            this.operationalInfo.put("databaseUser", md.getUserName());
            this.operationalInfo.put("databaseProduct", md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            this.operationalInfo.put("databaseDriver", md.getDriverName() + " " + md.getDriverVersion());
            logger.infof("Database info: %s", (Object)this.operationalInfo.toString());
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to prepare operational info due database exception: " + e.getMessage()));
        }
    }

    protected void startGlobalStats(KeycloakSession session, int globalStatsIntervalSecs) {
        logger.debugf("Started Hibernate statistics with the interval %s seconds", globalStatsIntervalSecs);
        TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
        timer.scheduleTask((ScheduledTask)new HibernateStatsReporter(this.emf), (long)(globalStatsIntervalSecs * 1000));
    }

    void migration(MigrationStrategy strategy, boolean initializeEmpty, String schema, File databaseUpdateFile, Connection connection, KeycloakSession session) {
        JpaUpdaterProvider updater = (JpaUpdaterProvider)session.getProvider(JpaUpdaterProvider.class, "liquibase");
        JpaUpdaterProvider.Status status = updater.validate(connection, schema);
        if (status == JpaUpdaterProvider.Status.VALID) {
            logger.debug((Object)"Database is up-to-date");
        } else if (status == JpaUpdaterProvider.Status.EMPTY) {
            if (initializeEmpty) {
                this.update(connection, schema, session, updater);
            } else {
                switch (strategy) {
                    case UPDATE: {
                        this.update(connection, schema, session, updater);
                        break;
                    }
                    case MANUAL: {
                        this.export(connection, schema, databaseUpdateFile, session, updater);
                        throw new ServerStartupError("Database not initialized, please initialize database with " + databaseUpdateFile.getAbsolutePath(), false);
                    }
                    case VALIDATE: {
                        throw new ServerStartupError("Database not initialized, please enable database initialization", false);
                    }
                }
            }
        } else {
            switch (strategy) {
                case UPDATE: {
                    this.update(connection, schema, session, updater);
                    break;
                }
                case MANUAL: {
                    this.export(connection, schema, databaseUpdateFile, session, updater);
                    throw new ServerStartupError("Database not up-to-date, please migrate database with " + databaseUpdateFile.getAbsolutePath(), false);
                }
                case VALIDATE: {
                    throw new ServerStartupError("Database not up-to-date, please enable database migration", false);
                }
            }
        }
    }

    protected void update(final Connection connection, final String schema, KeycloakSession session, final JpaUpdaterProvider updater) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), (KeycloakSessionTask)new KeycloakSessionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(KeycloakSession lockSession) {
                DBLockManager dbLockManager = new DBLockManager(lockSession);
                DBLockProvider dbLock2 = dbLockManager.getDBLock();
                dbLock2.waitForLock(DBLockProvider.Namespace.DATABASE);
                try {
                    updater.update(connection, schema);
                }
                finally {
                    dbLock2.releaseLock();
                }
            }
        });
    }

    protected void export(final Connection connection, final String schema, final File databaseUpdateFile, KeycloakSession session, final JpaUpdaterProvider updater) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), (KeycloakSessionTask)new KeycloakSessionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(KeycloakSession lockSession) {
                DBLockManager dbLockManager = new DBLockManager(lockSession);
                DBLockProvider dbLock2 = dbLockManager.getDBLock();
                dbLock2.waitForLock(DBLockProvider.Namespace.DATABASE);
                try {
                    updater.export(connection, schema, databaseUpdateFile);
                }
                finally {
                    dbLock2.releaseLock();
                }
            }
        });
    }

    @Override
    public Connection getConnection() {
        try {
            String dataSourceLookup = this.config.get("dataSource");
            if (dataSourceLookup != null) {
                DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceLookup);
                return dataSource.getConnection();
            }
            String url = this.config.get("url");
            String driver = this.config.get("driver");
            url = this.augmentJdbcUrl(driver, url);
            Class.forName(driver);
            return DriverManager.getConnection(StringPropertyReplacer.replaceProperties((String)url, System.getProperties()::getProperty), this.config.get("user"), this.config.get("password"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to connect to database", e);
        }
    }

    private String augmentJdbcUrl(String driver, String url) {
        if (driver.equals("org.postgresql.xa.PGXADataSource") || driver.equals("org.postgresql.Driver")) {
            url = this.addPostgreSQLKeywords(url);
        }
        if (driver.equals("org.h2.Driver")) {
            url = this.addH2NonKeywords(url);
        }
        return url;
    }

    @Override
    public String getSchema() {
        String schema = this.config.get("schema");
        if (schema != null && schema.contains("-") && !Boolean.parseBoolean(System.getProperty(GlobalConfiguration.PRESERVE_SCHEMA_CASE.getKey()))) {
            System.setProperty(GlobalConfiguration.PRESERVE_SCHEMA_CASE.getKey(), "true");
            logger.warnf("The passed schema '%s' contains a dash. Setting liquibase config option PRESERVE_SCHEMA_CASE to true. See https://github.com/keycloak/keycloak/issues/20870 for more information.", (Object)schema);
        }
        return schema;
    }

    public Map<String, String> getOperationalInfo() {
        return this.operationalInfo;
    }

    private MigrationStrategy getMigrationStrategy() {
        String migrationStrategy = this.config.get("migrationStrategy");
        if (migrationStrategy == null) {
            migrationStrategy = this.config.get("databaseSchema");
        }
        if (migrationStrategy != null) {
            return MigrationStrategy.valueOf(migrationStrategy.toUpperCase());
        }
        return MigrationStrategy.UPDATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateModel(KeycloakSession session) {
        DBLockManager dbLockManager = new DBLockManager(session);
        DBLockProvider dbLock = dbLockManager.getDBLock();
        dbLock.waitForLock(DBLockProvider.Namespace.DATABASE);
        try {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)session.getKeycloakSessionFactory(), MigrationModelManager::migrate);
        }
        finally {
            dbLock.releaseLock();
        }
    }

    private String addH2NonKeywords(String jdbcUrl) {
        if (!((String)jdbcUrl).contains("NON_KEYWORDS=")) {
            jdbcUrl = (String)jdbcUrl + ";NON_KEYWORDS=VALUE";
        }
        return jdbcUrl;
    }

    private String addPostgreSQLKeywords(String jdbcUrl) {
        if (!((String)jdbcUrl).contains("targetServerType=")) {
            jdbcUrl = ((String)jdbcUrl).contains("?") ? (String)jdbcUrl + "&" : (String)jdbcUrl + "?";
            jdbcUrl = (String)jdbcUrl + "targetServerType=primary";
        }
        return jdbcUrl;
    }

    static enum MigrationStrategy {
        UPDATE,
        VALIDATE,
        MANUAL;

    }
}

