/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6NeighborSolicitationPacket
extends AbstractPacket {
    private static final long serialVersionUID = 1178892836174110046L;
    private final IcmpV6NeighborSolicitationHeader header;

    public static IcmpV6NeighborSolicitationPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV6NeighborSolicitationPacket(rawData, offset, length);
    }

    private IcmpV6NeighborSolicitationPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV6NeighborSolicitationHeader(rawData, offset, length);
    }

    private IcmpV6NeighborSolicitationPacket(Builder builder2) {
        if (builder2 == null || builder2.targetAddress == null || builder2.options == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.targetAddress: ").append(builder2.targetAddress).append(" builder.options: ").append(builder2.options);
            throw new NullPointerException(sb.toString());
        }
        this.header = new IcmpV6NeighborSolicitationHeader(builder2);
    }

    @Override
    public IcmpV6NeighborSolicitationHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6NeighborSolicitationHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -2707375708511831386L;
        private static final int RESERVED_OFFSET = 0;
        private static final int RESERVED_SIZE = 4;
        private static final int TARGET_ADDRESS_OFFSET = 4;
        private static final int TARGET_ADDRESS_SIZE = 16;
        private static final int OPTIONS_OFFSET = 20;
        private final int reserved;
        private final Inet6Address targetAddress;
        private final List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options;

        private IcmpV6NeighborSolicitationHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newOne;
            if (length < 20) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The raw data must be more than ").append(19).append("bytes").append(" to build this header. raw data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.reserved = ByteArrays.getInt(rawData, 0 + offset);
            this.targetAddress = ByteArrays.getInet6Address(rawData, 4 + offset);
            this.options = new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>();
            for (int currentOffsetInHeader = 20; currentOffsetInHeader < length; currentOffsetInHeader += newOne.length()) {
                IpV6NeighborDiscoveryOptionType type = IpV6NeighborDiscoveryOptionType.getInstance(rawData[currentOffsetInHeader + offset]);
                try {
                    newOne = PacketFactories.getFactory(IcmpV6CommonPacket.IpV6NeighborDiscoveryOption.class, IpV6NeighborDiscoveryOptionType.class).newInstance(rawData, currentOffsetInHeader + offset, length - currentOffsetInHeader, type);
                }
                catch (Exception e) {
                    break;
                }
                this.options.add(newOne);
            }
        }

        private IcmpV6NeighborSolicitationHeader(Builder builder2) {
            this.reserved = builder2.reserved;
            this.targetAddress = builder2.targetAddress;
            this.options = new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>(builder2.options);
        }

        public int getReserved() {
            return this.reserved;
        }

        public Inet6Address getTargetAddress() {
            return this.targetAddress;
        }

        public List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> getOptions() {
            return new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>(this.options);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.reserved));
            rawFields.add(ByteArrays.toByteArray(this.targetAddress));
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption o : this.options) {
                rawFields.add(o.getRawData());
            }
            return rawFields;
        }

        @Override
        protected int calcLength() {
            int len = 0;
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption o : this.options) {
                len += o.length();
            }
            return len + 20;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv6 Neighbor Solicitation Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Reserved: ").append(this.reserved).append(ls);
            sb.append("  Target Address: ").append(this.targetAddress).append(ls);
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption opt : this.options) {
                sb.append("  Option: ").append(opt).append(ls);
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV6NeighborSolicitationHeader other = (IcmpV6NeighborSolicitationHeader)obj;
            return this.targetAddress.equals(other.targetAddress) && this.reserved == other.reserved && this.options.equals(other.options);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.reserved;
            result = 31 * result + this.targetAddress.hashCode();
            result = 31 * result + this.options.hashCode();
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private int reserved;
        private Inet6Address targetAddress;
        private List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options;

        public Builder() {
        }

        private Builder(IcmpV6NeighborSolicitationPacket packet) {
            this.reserved = packet.header.reserved;
            this.targetAddress = packet.header.targetAddress;
            this.options = packet.header.options;
        }

        public Builder reserved(int reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder targetAddress(Inet6Address targetAddress) {
            this.targetAddress = targetAddress;
            return this;
        }

        public Builder options(List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options2) {
            this.options = options2;
            return this;
        }

        @Override
        public IcmpV6NeighborSolicitationPacket build() {
            return new IcmpV6NeighborSolicitationPacket(this);
        }
    }
}

