/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import java.io.IOException;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.SafeParseIqProvider;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsExtension;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsIQ;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class ColibriStatsIqProvider
extends SafeParseIqProvider<ColibriStatsIQ> {
    public ColibriStatsIqProvider() {
        ProviderManager.addIQProvider("stats", "http://jitsi.org/protocol/colibri", this);
        ProviderManager.addExtensionProvider("stats", "http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<ColibriStatsExtension>(ColibriStatsExtension.class));
        ProviderManager.addExtensionProvider("stat", "http://jitsi.org/protocol/colibri", new DefaultPacketExtensionProvider<ColibriStatsExtension.Stat>(ColibriStatsExtension.Stat.class));
    }

    @Override
    protected ColibriStatsIQ doParse(XmlPullParser parser2) throws XmlPullParserException, IOException {
        ColibriStatsIQ iq;
        String namespace = parser2.getNamespace();
        if ("stats".equals(parser2.getName()) && "http://jitsi.org/protocol/colibri".equals(namespace)) {
            ColibriStatsIQ statsIQ;
            String rootElement = parser2.getName();
            iq = statsIQ = new ColibriStatsIQ();
            ColibriStatsExtension.Stat stat = null;
            boolean done = false;
            while (!done) {
                switch (parser2.next()) {
                    case START_ELEMENT: {
                        String name = parser2.getName();
                        if (!"stat".equals(name)) break;
                        stat = new ColibriStatsExtension.Stat();
                        String statName = parser2.getAttributeValue("", "name");
                        stat.setName(statName);
                        String statValue = parser2.getAttributeValue("", "value");
                        stat.setValue(statValue);
                        break;
                    }
                    case END_ELEMENT: {
                        String name = parser2.getName();
                        if (rootElement.equals(name)) {
                            done = true;
                            break;
                        }
                        if (!"stat".equals(name) || stat == null) break;
                        statsIQ.addStat(stat);
                        stat = null;
                        break;
                    }
                }
            }
        } else {
            iq = null;
        }
        return iq;
    }
}

