/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.monitoring.model.RetrieveDimensionStatesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RetrieveDimensionStatesRequest
extends BmcRequest<RetrieveDimensionStatesDetails> {
    private String alarmId;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private RetrieveDimensionStatesDetails retrieveDimensionStatesDetails;

    public String getAlarmId() {
        return this.alarmId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public RetrieveDimensionStatesDetails getRetrieveDimensionStatesDetails() {
        return this.retrieveDimensionStatesDetails;
    }

    @InternalSdk
    public RetrieveDimensionStatesDetails getBody$() {
        return this.retrieveDimensionStatesDetails;
    }

    public Builder toBuilder() {
        return new Builder().alarmId(this.alarmId).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).retrieveDimensionStatesDetails(this.retrieveDimensionStatesDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",alarmId=").append(String.valueOf(this.alarmId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",retrieveDimensionStatesDetails=").append(String.valueOf((Object)this.retrieveDimensionStatesDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetrieveDimensionStatesRequest)) {
            return false;
        }
        RetrieveDimensionStatesRequest other = (RetrieveDimensionStatesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.alarmId, other.alarmId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.retrieveDimensionStatesDetails, (Object)other.retrieveDimensionStatesDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.alarmId == null ? 43 : this.alarmId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.retrieveDimensionStatesDetails == null ? 43 : this.retrieveDimensionStatesDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RetrieveDimensionStatesRequest, RetrieveDimensionStatesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String alarmId = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;
        private RetrieveDimensionStatesDetails retrieveDimensionStatesDetails = null;

        public Builder alarmId(String alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder retrieveDimensionStatesDetails(RetrieveDimensionStatesDetails retrieveDimensionStatesDetails) {
            this.retrieveDimensionStatesDetails = retrieveDimensionStatesDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RetrieveDimensionStatesRequest o) {
            this.alarmId(o.getAlarmId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.retrieveDimensionStatesDetails(o.getRetrieveDimensionStatesDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RetrieveDimensionStatesRequest build() {
            RetrieveDimensionStatesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RetrieveDimensionStatesDetails body) {
            this.retrieveDimensionStatesDetails(body);
            return this;
        }

        public RetrieveDimensionStatesRequest buildWithoutInvocationCallback() {
            RetrieveDimensionStatesRequest request = new RetrieveDimensionStatesRequest();
            request.alarmId = this.alarmId;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.retrieveDimensionStatesDetails = this.retrieveDimensionStatesDetails;
            return request;
        }
    }
}

