/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.UpdateBuildPipelineDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateBuildPipelineRequest
extends BmcRequest<UpdateBuildPipelineDetails> {
    private String buildPipelineId;
    private UpdateBuildPipelineDetails updateBuildPipelineDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getBuildPipelineId() {
        return this.buildPipelineId;
    }

    public UpdateBuildPipelineDetails getUpdateBuildPipelineDetails() {
        return this.updateBuildPipelineDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateBuildPipelineDetails getBody$() {
        return this.updateBuildPipelineDetails;
    }

    public Builder toBuilder() {
        return new Builder().buildPipelineId(this.buildPipelineId).updateBuildPipelineDetails(this.updateBuildPipelineDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",buildPipelineId=").append(String.valueOf(this.buildPipelineId));
        sb.append(",updateBuildPipelineDetails=").append(String.valueOf((Object)this.updateBuildPipelineDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateBuildPipelineRequest)) {
            return false;
        }
        UpdateBuildPipelineRequest other = (UpdateBuildPipelineRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.buildPipelineId, other.buildPipelineId) && Objects.equals((Object)this.updateBuildPipelineDetails, (Object)other.updateBuildPipelineDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.buildPipelineId == null ? 43 : this.buildPipelineId.hashCode());
        result = result * 59 + (this.updateBuildPipelineDetails == null ? 43 : this.updateBuildPipelineDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateBuildPipelineRequest, UpdateBuildPipelineDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String buildPipelineId = null;
        private UpdateBuildPipelineDetails updateBuildPipelineDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder buildPipelineId(String buildPipelineId) {
            this.buildPipelineId = buildPipelineId;
            return this;
        }

        public Builder updateBuildPipelineDetails(UpdateBuildPipelineDetails updateBuildPipelineDetails) {
            this.updateBuildPipelineDetails = updateBuildPipelineDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateBuildPipelineRequest o) {
            this.buildPipelineId(o.getBuildPipelineId());
            this.updateBuildPipelineDetails(o.getUpdateBuildPipelineDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateBuildPipelineRequest build() {
            UpdateBuildPipelineRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateBuildPipelineDetails body) {
            this.updateBuildPipelineDetails(body);
            return this;
        }

        public UpdateBuildPipelineRequest buildWithoutInvocationCallback() {
            UpdateBuildPipelineRequest request = new UpdateBuildPipelineRequest();
            request.buildPipelineId = this.buildPipelineId;
            request.updateBuildPipelineDetails = this.updateBuildPipelineDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

