/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.timers.InstanceWatcher;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class TimesCollectorPeer {
    private List<Reference<Object>> files = new ArrayList<Reference<Object>>();
    private Map<Object, Map<String, Description>> fo2Key2Desc = new WeakHashMap<Object, Map<String, Description>>();
    private static final TimesCollectorPeer INSTANCE = new TimesCollectorPeer();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final RequestProcessor CLEANER = new RequestProcessor("CleanableWeakReference");

    public static TimesCollectorPeer getDefault() {
        return INSTANCE;
    }

    private TimesCollectorPeer() {
    }

    public void reportTime(Object fo, String key, String message, long time) {
        Map<String, Description> key2Desc = this.getKey2Desc(fo);
        Description desc = new Description(message, time);
        key2Desc.put(key, desc);
        this.pcs.firePropertyChange("PROP", fo, key);
    }

    public void reportReference(Object fo, String key, String message, Object object) {
        Map<String, Description> key2Desc = this.getKey2Desc(fo);
        Description d = key2Desc.get(key);
        assert (d == null || d instanceof ObjectCountDescripton) : "Illegal state";
        ObjectCountDescripton ocd = d == null ? new ObjectCountDescripton(this, fo, key, message) : (ObjectCountDescripton)d;
        ocd.add(object);
        key2Desc.put(key, ocd);
        this.pcs.firePropertyChange("PROP", fo, key);
    }

    private synchronized Map<String, Description> getKey2Desc(final Object fo) {
        Map<String, Description> result = this.fo2Key2Desc.get(fo);
        if (result == null) {
            this.files.add(new CleanableWeakReference<Object>(fo));
            result = Collections.synchronizedMap(new LinkedHashMap());
            this.fo2Key2Desc.put(fo, result);
            this.pcs.firePropertyChange("fos", null, fo);
            if (fo instanceof FileObject) {
                ((FileObject)fo).addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDeleted(FileEvent ev) {
                        TimesCollectorPeer.this.fileDeletedSync(ev, (FileObject)fo);
                    }
                });
            }
        }
        return result;
    }

    final synchronized void fileDeletedSync(FileEvent ev, FileObject fo) {
        for (Reference<Object> r : this.files) {
            if (r.get() != fo) continue;
            this.files.remove(r);
            break;
        }
        this.fo2Key2Desc.remove(fo);
        this.pcs.firePropertyChange("fos", null, null);
    }

    public Description getDescription(Object fo, String key) {
        return this.getKey2Desc(fo).get(key);
    }

    public Collection<String> getKeysForFile(Object fo) {
        return this.getKey2Desc(fo).keySet();
    }

    public synchronized Collection<Object> getFiles() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Reference<Object> r : this.files) {
            Object f = r.get();
            if (f == null) continue;
            result.add(f);
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void select(Object fo) {
        this.getKey2Desc(fo);
        this.pcs.firePropertyChange("selected", null, fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cleanFiles(CleanableWeakReference cwr) {
        TimesCollectorPeer timesCollectorPeer = this;
        synchronized (timesCollectorPeer) {
            this.files.remove(cwr);
        }
        this.pcs.firePropertyChange("fos", null, null);
    }

    public static class Description {
        private String message;
        private long time;

        public Description(String message, long time) {
            this.message = message;
            this.time = time;
        }

        public String getMessage() {
            return this.message;
        }

        public long getTime() {
            return this.time;
        }
    }

    public static class ObjectCountDescripton
    extends Description
    implements ChangeListener {
        private TimesCollectorPeer tcp;
        private Reference<Object> fo;
        private String key;
        private InstanceWatcher iw = new InstanceWatcher();

        public ObjectCountDescripton(TimesCollectorPeer tcp, Object fo, String key, String message) {
            super(message, 0L);
            this.tcp = tcp;
            this.fo = new WeakReference<Object>(fo);
            this.key = key;
            this.iw.addChangeListener(this);
        }

        @Override
        public long getTime() {
            return this.iw.size();
        }

        public Collection getInstances() {
            return this.iw.getInstances();
        }

        private void add(Object o) {
            this.iw.add(o);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object file = this.fo.get();
            if (file != null) {
                this.tcp.pcs.firePropertyChange("PROP", file, this.key);
            }
        }
    }

    private class CleanableWeakReference<T>
    extends WeakReference<T>
    implements Runnable {
        public CleanableWeakReference(T o) {
            super(o, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            if (!CLEANER.isRequestProcessorThread()) {
                CLEANER.post((Runnable)this);
                return;
            }
            TimesCollectorPeer.this.cleanFiles(this);
        }
    }
}

