/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathModifier;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DataFilesProviderImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOrRenameOperationImplementation;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class ProjectOperations {
    private static final Logger LOG = Logger.getLogger(ProjectOperations.class.getName());
    private static final String TARGET_CLEAN = "clean";

    private ProjectOperations() {
        throw new IllegalStateException("No instance allowed.");
    }

    @NonNull
    public static ProjectOperationsBuilder createBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper helper, @NonNull ReferenceHelper refHelper, @NonNull SourceRoots sources, @NonNull SourceRoots tests) {
        return new ProjectOperationsBuilder(project, eval, helper, refHelper, sources, tests);
    }

    public static final class ProjectOperationsBuilder {
        private final Project project;
        private final PropertyEvaluator eval;
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final SourceRoots sources;
        private final SourceRoots tests;
        private final List<String> additionalMetadataFiles;
        private final List<String> additionalDataFiles;
        private final List<String> cleanTargets;
        private final Set<String> privateProps;
        private final Map<String, Pair<String, Boolean>> updatedProps;
        private Callback callback;
        private String buildScriptProperty = "buildfile";

        private ProjectOperationsBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper helper, @NonNull ReferenceHelper refHelper, @NonNull SourceRoots sources, @NonNull SourceRoots tests) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"refHelper", (Object)refHelper);
            Parameters.notNull((CharSequence)"sources", (Object)sources);
            Parameters.notNull((CharSequence)"tests", (Object)tests);
            this.project = project;
            this.eval = eval;
            this.helper = helper;
            this.refHelper = refHelper;
            this.sources = sources;
            this.tests = tests;
            this.additionalMetadataFiles = new ArrayList<String>();
            this.additionalDataFiles = new ArrayList<String>();
            this.cleanTargets = new ArrayList<String>();
            this.privateProps = new HashSet<String>();
            this.updatedProps = new HashMap<String, Pair<String, Boolean>>();
        }

        @NonNull
        public ProjectOperationsBuilder setBuildScriptProperty(@NonNull String propertyName) {
            Parameters.notNull((CharSequence)"propertyName", (Object)propertyName);
            this.buildScriptProperty = propertyName;
            return this;
        }

        @NonNull
        public ProjectOperationsBuilder addCleanTargets(String ... cleanTargets) {
            Parameters.notNull((CharSequence)"cleanTargets", (Object)cleanTargets);
            Collections.addAll(this.cleanTargets, cleanTargets);
            return this;
        }

        @NonNull
        public ProjectOperationsBuilder addMetadataFiles(String ... paths) {
            Parameters.notNull((CharSequence)"paths", (Object)paths);
            Collections.addAll(this.additionalMetadataFiles, paths);
            return this;
        }

        @NonNull
        public ProjectOperationsBuilder addDataFiles(String ... paths) {
            Parameters.notNull((CharSequence)"paths", (Object)paths);
            Collections.addAll(this.additionalDataFiles, paths);
            return this;
        }

        @NonNull
        public ProjectOperationsBuilder addPreservedPrivateProperties(String ... properties) {
            Parameters.notNull((CharSequence)"properties", (Object)properties);
            Collections.addAll(this.privateProps, properties);
            return this;
        }

        @NonNull
        public ProjectOperationsBuilder addUpdatedNameProperty(@NonNull String propertyName, @NullAllowed String propertyPattern, boolean antName) {
            Parameters.notNull((CharSequence)"propertyName", (Object)propertyName);
            if (propertyPattern == null) {
                propertyPattern = "{0}";
            }
            this.updatedProps.put(propertyName, (Pair<String, Boolean>)Pair.of((Object)propertyPattern, (Object)antName));
            return this;
        }

        @NonNull
        public ProjectOperationsBuilder setCallback(@NonNull Callback callback) {
            Parameters.notNull((CharSequence)"callback", (Object)callback);
            this.callback = callback;
            return this;
        }

        @NonNull
        public DataFilesProviderImplementation build() {
            if (this.cleanTargets.isEmpty()) {
                this.cleanTargets.add(ProjectOperations.TARGET_CLEAN);
            }
            return new Operations(this.project, this.eval, this.helper, this.refHelper, this.sources, this.tests, this.buildScriptProperty, this.additionalMetadataFiles, this.additionalDataFiles, this.cleanTargets, this.privateProps, this.updatedProps, this.callback);
        }
    }

    private static class Operations
    implements DataFilesProviderImplementation,
    DeleteOperationImplementation,
    CopyOperationImplementation,
    MoveOrRenameOperationImplementation {
        private final Project project;
        private final PropertyEvaluator eval;
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final SourceRoots sources;
        private final SourceRoots tests;
        private final String buildScriptProperty;
        private final List<? extends String> additionalMetadataFiles;
        private final List<? extends String> additionalDataFiles;
        private final List<? extends String> cleanTargets;
        private final Set<? extends String> privateProps;
        private final Map<String, Pair<String, Boolean>> updatedProps;
        private final Callback callback;
        private final Map<String, String> privatePropsToRestore = new HashMap<String, String>();
        private String absolutesRelPath;
        private String libraryPath;
        private File libraryFile;
        private boolean libraryWithinProject;
        private FileSystem configs;
        private Collection<Dependency> dependenciesToFix;

        Operations(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper helper, @NonNull ReferenceHelper refHelper, @NonNull SourceRoots sources, @NonNull SourceRoots tests, @NonNull String buildScriptProperty, @NonNull List<? extends String> additionalMetadataFiles, @NonNull List<? extends String> additionalDataFiles, @NonNull List<? extends String> cleanTargets, @NonNull Set<? extends String> privateProps, @NonNull Map<String, Pair<String, Boolean>> updatedProps, @NullAllowed Callback callback) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"refHelper", (Object)refHelper);
            Parameters.notNull((CharSequence)"sources", (Object)sources);
            Parameters.notNull((CharSequence)"tests", (Object)tests);
            Parameters.notNull((CharSequence)"buildScriptProperty", (Object)buildScriptProperty);
            Parameters.notNull((CharSequence)"additionalMetadataFiles", additionalMetadataFiles);
            Parameters.notNull((CharSequence)"additionalDataFiles", additionalDataFiles);
            Parameters.notNull((CharSequence)"cleanTargets", cleanTargets);
            Parameters.notNull((CharSequence)"privateProps", privateProps);
            Parameters.notNull((CharSequence)"updatedProps", updatedProps);
            this.project = project;
            this.eval = eval;
            this.helper = helper;
            this.refHelper = refHelper;
            this.sources = sources;
            this.tests = tests;
            this.buildScriptProperty = buildScriptProperty;
            this.additionalMetadataFiles = additionalMetadataFiles;
            this.additionalDataFiles = additionalDataFiles;
            this.cleanTargets = cleanTargets;
            this.privateProps = privateProps;
            this.updatedProps = updatedProps;
            this.callback = callback;
        }

        public void notifyDeleting() throws IOException {
            this.before(Callback.Operation.DELETE);
            this.clean();
        }

        public void notifyDeleted() throws IOException {
            this.helper.getAntProjectHelper().notifyDeleted();
            this.after(Callback.Operation.DELETE, null, null);
        }

        public List<FileObject> getMetadataFiles() {
            FileObject projectDirectory = this.project.getProjectDirectory();
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            Operations.addFile(projectDirectory, "nbproject", files);
            Operations.addFile(projectDirectory, CommonProjectUtils.getBuildXmlName(this.eval, this.buildScriptProperty), files);
            for (String string : this.additionalMetadataFiles) {
                Operations.addFile(projectDirectory, string, files);
            }
            return files;
        }

        public List<FileObject> getDataFiles() {
            FileObject fileObject;
            File f;
            FileObject projectDirectory = this.project.getProjectDirectory();
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            Collections.addAll(files, this.sources.getRoots());
            Collections.addAll(files, this.tests.getRoots());
            AntProjectHelper aph = this.helper.getAntProjectHelper();
            if (aph.getLibrariesLocation() != null && (f = aph.resolveFile(aph.getLibrariesLocation())) != null && f.exists() && FileUtil.isParentOf((FileObject)projectDirectory, (FileObject)(fileObject = FileUtil.toFileObject((File)f).getParent()))) {
                files.add(fileObject);
            }
            for (String string : this.additionalDataFiles) {
                Operations.addFile(projectDirectory, string, files);
            }
            return files;
        }

        public void notifyCopying() throws IOException {
            this.before(Callback.Operation.COPY);
            this.rememberLibraryLocation();
            this.readPrivateProperties();
            this.rememberConfigurations();
        }

        public void notifyCopied(Project original, File originalPath, String nueName) throws IOException {
            if (original == null) {
                return;
            }
            Operations origOperations = (Operations)original.getLookup().lookup(Operations.class);
            this.fixLibraryLocation(origOperations);
            this.fixPrivateProperties(origOperations);
            this.updateProjectProperties(nueName);
            this.refHelper.fixReferences(originalPath);
            this.restoreConfigurations(origOperations);
            this.after(Callback.Operation.COPY, nueName, null);
        }

        public void notifyRenaming() throws IOException {
            if (!this.helper.requestUpdate()) {
                throw new IOException(NbBundle.getMessage(ProjectOperations.class, (String)"MSG_OldProjectMetadata"));
            }
            this.before(Callback.Operation.RENAME);
            this.clean();
        }

        public void notifyRenamed(String nueName) throws IOException {
            this.updateProjectProperties(nueName);
            this.after(Callback.Operation.RENAME, nueName, null);
        }

        public void notifyMoving() throws IOException {
            if (!this.helper.requestUpdate()) {
                throw new IOException(NbBundle.getMessage(ProjectOperations.class, (String)"MSG_OldProjectMetadata"));
            }
            this.before(Callback.Operation.MOVE);
            this.rememberLibraryLocation();
            this.readPrivateProperties();
            this.rememberConfigurations();
            this.rememberDependencies();
            this.clean();
        }

        public void notifyMoved(Project original, File originalPath, String nueName) throws IOException {
            if (original == null) {
                this.helper.getAntProjectHelper().notifyDeleted();
                return;
            }
            Operations origOperations = (Operations)original.getLookup().lookup(Operations.class);
            this.fixLibraryLocation(origOperations);
            this.fixPrivateProperties(origOperations);
            this.updateProjectProperties(nueName);
            this.refHelper.fixReferences(originalPath);
            this.restoreConfigurations(origOperations);
            this.fixDependencies(origOperations);
            this.after(Callback.Operation.MOVE, nueName, (Pair<File, Project>)Pair.of((Object)originalPath, (Object)original));
        }

        private void clean() throws IOException {
            Properties p = new Properties();
            String buildXmlName = CommonProjectUtils.getBuildXmlName(this.eval, this.buildScriptProperty);
            FileObject buildXML = this.project.getProjectDirectory().getFileObject(buildXmlName);
            if (buildXML != null) {
                ActionUtils.runTarget((FileObject)buildXML, (String[])this.cleanTargets.toArray(new String[0]), (Properties)p).waitFinished();
            } else {
                LOG.log(Level.INFO, "Not cleaning the project: {0}, the build file: {1} does not exist.", new Object[]{ProjectUtils.getInformation((Project)this.project).getDisplayName(), buildXmlName});
            }
        }

        private void rememberLibraryLocation() {
            this.libraryWithinProject = false;
            this.absolutesRelPath = null;
            this.libraryPath = this.helper.getAntProjectHelper().getLibrariesLocation();
            if (this.libraryPath != null) {
                File prjRoot = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                this.libraryFile = PropertyUtils.resolveFile((File)prjRoot, (String)this.libraryPath);
                if (FileOwnerQuery.getOwner((URI)Utilities.toURI((File)this.libraryFile)) == this.project && this.libraryFile.getAbsolutePath().startsWith(prjRoot.getAbsolutePath())) {
                    this.libraryWithinProject = true;
                    FileObject fo = FileUtil.toFileObject((File)this.libraryFile);
                    if (new File(this.libraryPath).isAbsolute() && fo != null) {
                        this.absolutesRelPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fo);
                    }
                }
            }
        }

        private void readPrivateProperties() {
            ProjectManager.mutex().readAccess(new Runnable(){

                @Override
                public void run() {
                    privatePropsToRestore.clear();
                    for (String string : privateProps) {
                        this.backUpPrivateProp(string);
                    }
                }
            });
        }

        private void backUpPrivateProp(String propName) {
            assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
            String tmp = this.helper.getProperties("nbproject/private/private.properties").getProperty(propName);
            if (tmp != null) {
                this.privatePropsToRestore.put(propName, tmp);
            }
        }

        private void rememberConfigurations() {
            FileObject fo = this.project.getProjectDirectory().getFileObject("nbproject/private/config.properties");
            if (fo != null) {
                try {
                    FileSystem fs = FileUtil.createMemoryFileSystem();
                    FileUtil.copyFile((FileObject)fo, (FileObject)fs.getRoot(), (String)fo.getName());
                    fo = this.project.getProjectDirectory().getFileObject("nbproject/private/configs");
                    if (fo != null && fo.isFolder()) {
                        FileObject cfgs = fs.getRoot().createFolder("configs");
                        for (FileObject child : fo.getChildren()) {
                            FileUtil.copyFile((FileObject)child, (FileObject)cfgs, (String)child.getName());
                        }
                    }
                    this.configs = fs;
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }

        private void rememberDependencies() {
            AntArtifactProvider aap = (AntArtifactProvider)this.project.getLookup().lookup(AntArtifactProvider.class);
            if (aap == null) {
                return;
            }
            Map<URI, Pair<AntArtifact, URI>> artifacts = Operations.createArtifactsMap(aap);
            HashSet<Project> dependencies = new HashSet<Project>();
            for (Project prj : OpenProjects.getDefault().getOpenProjects()) {
                SubprojectProvider spp = (SubprojectProvider)prj.getLookup().lookup(SubprojectProvider.class);
                if (spp == null || !spp.getSubprojects().contains(this.project)) continue;
                dependencies.add(prj);
            }
            ArrayList<Dependency> toFix = new ArrayList<Dependency>();
            for (Project depProject : dependencies) {
                for (SourceGroup sg : ProjectUtils.getSources((Project)depProject).getSourceGroups("java")) {
                    Set<URI> roots = Operations.classPathURIs(ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/compile"));
                    for (Map.Entry<URI, Pair<AntArtifact, URI>> e : artifacts.entrySet()) {
                        Dependency dep;
                        if (!roots.contains(e.getKey()) || !(dep = new Dependency(depProject, sg, (AntArtifact)e.getValue().first(), (URI)e.getValue().second())).remove()) continue;
                        toFix.add(dep);
                    }
                }
            }
            this.dependenciesToFix = toFix;
        }

        private void fixLibraryLocation(Operations original) throws IllegalArgumentException {
            String libPath = original.libraryPath;
            if (libPath != null) {
                if (!new File(libPath).isAbsolute()) {
                    if (!original.libraryWithinProject) {
                        File file = original.libraryFile;
                        if (file == null) {
                            return;
                        }
                        String relativized = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)file);
                        if (relativized != null) {
                            this.helper.getAntProjectHelper().setLibrariesLocation(relativized);
                        } else {
                            this.helper.getAntProjectHelper().setLibrariesLocation(file.getAbsolutePath());
                        }
                    }
                } else if (original.libraryWithinProject && original.absolutesRelPath != null) {
                    this.helper.getAntProjectHelper().setLibrariesLocation(PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)original.absolutesRelPath).getAbsolutePath());
                }
            }
        }

        private void fixPrivateProperties(final Operations original) {
            if (original != null && !original.privatePropsToRestore.isEmpty()) {
                ProjectManager.mutex().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        EditableProperties ep = helper.getProperties("nbproject/private/private.properties");
                        for (Map.Entry<String, String> entry : original.privatePropsToRestore.entrySet()) {
                            ep.put(entry.getKey(), entry.getValue());
                        }
                        helper.putProperties("nbproject/private/private.properties", ep);
                    }
                });
            }
        }

        private void restoreConfigurations(Operations original) {
            FileSystem fs = original.configs;
            original.configs = null;
            if (fs != null) {
                try {
                    FileObject configsFolder;
                    FileObject privateFolder;
                    FileObject fo = fs.getRoot().getFileObject("config.properties");
                    if (fo != null && (privateFolder = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)"nbproject/private")) != null) {
                        FileObject oldFile = privateFolder.getFileObject(fo.getName(), fo.getExt());
                        if (oldFile != null) {
                            privateFolder.refresh();
                            oldFile = privateFolder.getFileObject(fo.getName(), fo.getExt());
                            if (oldFile != null) {
                                oldFile.delete();
                            }
                        }
                        FileUtil.copyFile((FileObject)fo, (FileObject)privateFolder, (String)fo.getName());
                    }
                    if ((fo = fs.getRoot().getFileObject("configs")) != null && (configsFolder = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)"nbproject/private/configs")) != null) {
                        for (FileObject child : fo.getChildren()) {
                            FileUtil.copyFile((FileObject)child, (FileObject)configsFolder, (String)child.getName());
                        }
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }

        private void fixDependencies(Operations original) {
            Collection<Dependency> toFix = original.dependenciesToFix;
            if (toFix != null) {
                for (Dependency dep : toFix) {
                    dep.add(this.project);
                }
            }
        }

        private void updateProjectProperties(@NonNull String newName) {
            if (!this.updatedProps.isEmpty()) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)this.project);
                String oldName = pi.getDisplayName();
                EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
                for (Map.Entry<String, Pair<String, Boolean>> e : this.updatedProps.entrySet()) {
                    String propValue;
                    String propName = e.getKey();
                    String format = (String)e.getValue().first();
                    boolean antName = (Boolean)e.getValue().second();
                    Object[] objectArray = new Object[1];
                    Object object = objectArray[0] = antName ? PropertyUtils.getUsablePropertyName((String)oldName) : oldName;
                    String oldProp = MessageFormat.format(format, objectArray);
                    if (!oldProp.equals(propValue = ep.getProperty(propName))) continue;
                    String newProp = MessageFormat.format(format, antName ? PropertyUtils.getUsablePropertyName((String)newName) : newName);
                    ep.put(propName, newProp);
                }
                this.helper.putProperties("nbproject/project.properties", ep);
            }
        }

        private void before(@NonNull Callback.Operation operation) {
            if (this.callback != null) {
                this.callback.beforeOperation(operation);
            }
        }

        private void after(@NonNull Callback.Operation operation, @NullAllowed String newName, @NullAllowed Pair<File, Project> oldProject) {
            if (this.callback != null) {
                this.callback.afterOperation(operation, newName, oldProject);
            }
        }

        private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
            FileObject file = projectDirectory.getFileObject(fileName);
            if (file != null) {
                result.add(file);
            }
        }

        @NonNull
        private static Map<URI, Pair<AntArtifact, URI>> createArtifactsMap(@NonNull AntArtifactProvider aap) {
            HashMap<URI, Pair<AntArtifact, URI>> res = new HashMap<URI, Pair<AntArtifact, URI>>();
            for (AntArtifact aa : aap.getBuildArtifacts()) {
                for (URI uri : aa.getArtifactLocations()) {
                    URI absoluteURI = uri.isAbsolute() ? uri : Operations.resolve(aa.getProject().getProjectDirectory(), uri);
                    res.put(absoluteURI, (Pair<AntArtifact, URI>)Pair.of((Object)aa, (Object)uri));
                }
            }
            return res;
        }

        @NonNull
        private static URI resolve(@NonNull FileObject prjDir, @NonNull URI relative) {
            return BaseUtilities.normalizeURI((URI)prjDir.toURI().resolve(relative));
        }

        @NonNull
        private static Set<URI> classPathURIs(@NullAllowed ClassPath cp) {
            HashSet<URI> res = new HashSet<URI>();
            if (cp != null) {
                for (ClassPath.Entry e : cp.entries()) {
                    try {
                        URL rootUrl = e.getURL();
                        URL fileURL = FileUtil.getArchiveFile((URL)rootUrl);
                        if (fileURL == null) {
                            fileURL = rootUrl;
                        }
                        res.add(fileURL.toURI());
                    }
                    catch (URISyntaxException ex) {
                        LOG.log(Level.WARNING, "Cannot convert to URI: {0}, reason: {1}", new Object[]{e.getURL(), ex.getMessage()});
                    }
                }
            }
            return res;
        }

        private static class Dependency {
            private final Project project;
            private final SourceGroup root;
            private final AntArtifact onArt;
            private final URI onLoc;

            Dependency(@NonNull Project project, @NonNull SourceGroup root, @NonNull AntArtifact onArt, @NonNull URI onLoc) {
                this.project = project;
                this.root = root;
                this.onArt = onArt;
                this.onLoc = onLoc;
            }

            boolean remove() {
                ClassPathModifier cpm = (ClassPathModifier)((Object)this.project.getLookup().lookup(ClassPathModifier.class));
                boolean success = false;
                if (cpm != null) {
                    try {
                        cpm.removeAntArtifacts(new AntArtifact[]{this.onArt}, new URI[]{this.onLoc}, this.root, "classpath/compile");
                        success = true;
                    }
                    catch (IOException | UnsupportedOperationException ex) {
                        LOG.log(Level.INFO, "Cannot fix dependencies in project: {0}", ProjectUtils.getInformation((Project)this.project).getDisplayName());
                    }
                }
                return success;
            }

            boolean add(@NonNull Project newProject) {
                boolean success = false;
                AntArtifactProvider aap = (AntArtifactProvider)newProject.getLookup().lookup(AntArtifactProvider.class);
                ClassPathModifier cpm = (ClassPathModifier)((Object)this.project.getLookup().lookup(ClassPathModifier.class));
                if (aap != null && cpm != null) {
                    AntArtifact newOn = null;
                    URI newOnLoc = null;
                    for (AntArtifact a : aap.getBuildArtifacts()) {
                        if (!Objects.equals(a.getType(), this.onArt.getType()) || !Objects.equals(a.getTargetName(), this.onArt.getTargetName()) || !Objects.equals(a.getCleanTargetName(), this.onArt.getCleanTargetName())) continue;
                        newOn = a;
                        int index = 0;
                        URI[] oal = this.onArt.getArtifactLocations();
                        for (int i = 0; i < oal.length; ++i) {
                            if (!oal[i].equals(this.onLoc)) continue;
                            index = i;
                            break;
                        }
                        newOnLoc = a.getArtifactLocations()[index];
                        break;
                    }
                    if (newOn != null) {
                        try {
                            cpm.addAntArtifacts(new AntArtifact[]{newOn}, new URI[]{newOnLoc}, this.root, "classpath/compile");
                            success = true;
                        }
                        catch (IOException | UnsupportedOperationException ex) {
                            LOG.log(Level.INFO, "Cannot fix dependencies in project: {0}", ProjectUtils.getInformation((Project)this.project).getDisplayName());
                        }
                    }
                }
                return success;
            }

            public String toString() {
                return String.format("%s in %s depends on %s in %s", this.root.getName(), ProjectUtils.getInformation((Project)this.project).getDisplayName(), this.onLoc, ProjectUtils.getInformation((Project)this.onArt.getProject()).getDisplayName());
            }
        }
    }

    public static interface Callback {
        public void beforeOperation(@NonNull Operation var1);

        public void afterOperation(@NonNull Operation var1, @NullAllowed String var2, @NullAllowed Pair<File, Project> var3);

        public static enum Operation {
            DELETE,
            COPY,
            MOVE,
            RENAME;

        }
    }
}

