/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.JsfSupport;
import org.netbeans.modules.web.jsfapi.api.JsfVersion;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.spi.JsfSupportProvider;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfLibrariesSupport {
    private JTextComponent tc;
    private Map<DefaultLibraryInfo, LibraryImport> map = new EnumMap<DefaultLibraryInfo, LibraryImport>(DefaultLibraryInfo.class);
    private JsfSupport jsfs;

    public JsfLibrariesSupport(JTextComponent tc) {
        this.tc = tc;
        this.initLibraries(tc);
    }

    static JsfLibrariesSupport get(JTextComponent tc) {
        return new JsfLibrariesSupport(tc);
    }

    private void initLibraries(JTextComponent tc) {
        Document doc = tc.getDocument();
        FileObject file = DataLoadersBridge.getDefault().getFileObject(doc);
        if (file == null) {
            return;
        }
        this.jsfs = JsfSupportProvider.get((FileObject)file);
        if (this.jsfs == null) {
            return;
        }
        Source source = Source.create((Document)doc);
        final AtomicReference result = new AtomicReference();
        try {
            ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result pr;
                    ResultIterator htmlRi = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                    if (htmlRi != null && (pr = htmlRi.getParserResult()) instanceof HtmlParsingResult) {
                        result.set((HtmlParsingResult)pr);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        HtmlParsingResult htmlresult = (HtmlParsingResult)result.get();
        Map ns2prefixes = htmlresult != null ? htmlresult.getSyntaxAnalyzerResult().getAllDeclaredNamespaces() : Collections.emptyMap();
        for (DefaultLibraryInfo libraryInfo : DefaultLibraryInfo.values()) {
            Library lib;
            LibraryImport libraryimport = new LibraryImport();
            libraryimport.lib = lib = this.jsfs.getLibrary(libraryInfo.getNamespace());
            libraryimport.declaredPrefix = libraryInfo.getValidNamespaces().stream().map(ns2prefixes::get).filter(Objects::nonNull).filter(JsfLibrariesSupport.not(Collection::isEmpty)).map(c -> (String)c.iterator().next()).findFirst().orElse(null);
            this.map.put(libraryInfo, libraryimport);
        }
    }

    public void importLibraries(DefaultLibraryInfo ... linfos) {
        HashMap<Library, Object> toimport = new HashMap<Library, Object>();
        for (DefaultLibraryInfo li : linfos) {
            LibraryImport limport = this.map.get(li);
            assert (limport != null);
            if (limport.declaredPrefix != null) continue;
            toimport.put(limport.lib, null);
        }
        LibraryUtils.importLibrary((Document)this.tc.getDocument(), toimport);
    }

    public String getLibraryPrefix(DefaultLibraryInfo li) {
        LibraryImport limport = this.map.get(li);
        if (limport == null) {
            return li.getDefaultPrefix();
        }
        return limport.declaredPrefix != null ? limport.declaredPrefix : limport.lib.getDefaultPrefix();
    }

    public JsfVersion getJsfVersion() {
        return this.jsfs.getJsfVersion();
    }

    private static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    private static class LibraryImport {
        public Library lib;
        public String declaredPrefix;

        private LibraryImport() {
        }
    }
}

