/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import com.google.gson.Gson;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.developer.ContainerRepositoryItem;
import org.netbeans.modules.cloud.oracle.developer.ContainerTagItem;
import org.netbeans.modules.cloud.oracle.developer.ContainerTagNode;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.spi.lsp.CommandProvider;

public class IntegrationCommands
implements CommandProvider {
    private static final String COMMAND_ASSETS_GET = "nbls.cloud.assets.get";
    private static final String COMMAND_ASSETS_GET_IMAGE_VERSIONS = "nbls.cloud.assets.getImageVersions";
    private static final Set COMMANDS = new HashSet<String>(Arrays.asList("nbls.cloud.assets.get", "nbls.cloud.assets.getImageVersions"));
    private final Gson gson = new Gson();

    public Set<String> getCommands() {
        return Collections.unmodifiableSet(COMMANDS);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        if (COMMAND_ASSETS_GET.equals(command)) {
            String path = this.parseStringArgument(arguments);
            if (path != null) {
                List<OCIItem> items = CloudAssets.getDefault().getItems(path);
                result.complete(items);
            } else {
                result.cancel(true);
            }
        } else if (COMMAND_ASSETS_GET_IMAGE_VERSIONS.equals(command)) {
            List<OCIItem> repos = CloudAssets.getDefault().getItems("ContainerRepository");
            if (repos != null && repos.size() == 1) {
                ContainerRepositoryItem repo = (ContainerRepositoryItem)repos.get(0);
                List<ContainerTagItem> tags = ContainerTagNode.getContainerTags().apply(repo);
                HashMap<String, String> tagUrls = new HashMap<String, String>();
                for (ContainerTagItem tag : tags) {
                    tagUrls.put(tag.getName(), tag.getUrl());
                }
                result.complete(tagUrls);
            } else {
                result.cancel(true);
            }
        }
        return result;
    }

    private String parseStringArgument(List<Object> arguments) {
        if (!arguments.isEmpty()) {
            JsonPrimitive item = (JsonPrimitive)this.gson.fromJson(this.gson.toJson(arguments.get(0)), JsonPrimitive.class);
            return item.getAsString();
        }
        return null;
    }
}

