/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.ForInIteratorPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSForInIteratorObject;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSForInIterator
extends JSNonProxy
implements JSConstructorFactory,
PrototypeSupplier {
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("%ForInIteratorPrototype%");
    public static final JSForInIterator INSTANCE = new JSForInIterator();

    private JSForInIterator() {
    }

    public static JSForInIteratorObject create(JSContext context, JSRealm realm, JSDynamicObject iteratedObject, boolean iterateValues) {
        JSObjectFactory factory = context.getForInIteratorFactory();
        JSDynamicObject proto = factory.getPrototype(realm);
        Shape shape = factory.getShape(realm, proto);
        JSForInIteratorObject newObj = factory.initProto(new JSForInIteratorObject(shape, proto, iteratedObject, iterateValues), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, ForInIteratorPrototypeBuiltins.BUILTINS);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    @Override
    public TruffleString getClassName() {
        return Strings.UC_OBJECT;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return this.getClassName();
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getForInIteratorPrototype();
    }
}

