/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.ServiceIdRequestDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DetachServiceIdRequest
extends BmcRequest<ServiceIdRequestDetails> {
    private String serviceGatewayId;
    private ServiceIdRequestDetails detachServiceDetails;
    private String ifMatch;

    public String getServiceGatewayId() {
        return this.serviceGatewayId;
    }

    public ServiceIdRequestDetails getDetachServiceDetails() {
        return this.detachServiceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ServiceIdRequestDetails getBody$() {
        return this.detachServiceDetails;
    }

    public Builder toBuilder() {
        return new Builder().serviceGatewayId(this.serviceGatewayId).detachServiceDetails(this.detachServiceDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",serviceGatewayId=").append(String.valueOf(this.serviceGatewayId));
        sb.append(",detachServiceDetails=").append(String.valueOf((Object)this.detachServiceDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetachServiceIdRequest)) {
            return false;
        }
        DetachServiceIdRequest other = (DetachServiceIdRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.serviceGatewayId, other.serviceGatewayId) && Objects.equals((Object)this.detachServiceDetails, (Object)other.detachServiceDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.serviceGatewayId == null ? 43 : this.serviceGatewayId.hashCode());
        result = result * 59 + (this.detachServiceDetails == null ? 43 : this.detachServiceDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DetachServiceIdRequest, ServiceIdRequestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String serviceGatewayId = null;
        private ServiceIdRequestDetails detachServiceDetails = null;
        private String ifMatch = null;

        public Builder serviceGatewayId(String serviceGatewayId) {
            this.serviceGatewayId = serviceGatewayId;
            return this;
        }

        public Builder detachServiceDetails(ServiceIdRequestDetails detachServiceDetails) {
            this.detachServiceDetails = detachServiceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DetachServiceIdRequest o) {
            this.serviceGatewayId(o.getServiceGatewayId());
            this.detachServiceDetails(o.getDetachServiceDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DetachServiceIdRequest build() {
            DetachServiceIdRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ServiceIdRequestDetails body) {
            this.detachServiceDetails(body);
            return this;
        }

        public DetachServiceIdRequest buildWithoutInvocationCallback() {
            DetachServiceIdRequest request = new DetachServiceIdRequest();
            request.serviceGatewayId = this.serviceGatewayId;
            request.detachServiceDetails = this.detachServiceDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

