/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsController;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsElement;
import org.netbeans.modules.java.navigation.BreadCrumbsNodeImpl;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.openide.filesystems.FileObject;

public final class BreadCrumbsScanningTask
extends JavaParserResultTask {
    private static final String COLOR = "#707070";
    private final AtomicBoolean cancel = new AtomicBoolean();

    private BreadCrumbsScanningTask() {
        super(JavaSource.Phase.RESOLVED, TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        int caretPosition;
        this.cancel.set(false);
        CompilationInfo info = CompilationInfo.get((Parser.Result)result);
        if (info == null) {
            return;
        }
        Document doc = info.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return;
        }
        if (!BreadcrumbsController.areBreadCrumsEnabled((Document)doc)) {
            return;
        }
        int n = caretPosition = event instanceof CursorMovedSchedulerEvent ? ((CursorMovedSchedulerEvent)event).getCaretOffset() : CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)result.getSnapshot().getSource().getFileObject());
        if (this.cancel.get()) {
            return;
        }
        BreadcrumbsElement[] rootAndSelection = BreadCrumbsScanningTask.rootAndSelection(info, caretPosition, this.cancel);
        if (this.cancel.get() || rootAndSelection == null) {
            return;
        }
        BreadcrumbsController.setBreadcrumbs((Document)doc, (BreadcrumbsElement)rootAndSelection[1]);
        info.putCachedValue(BreadCrumbsScanningTask.class, (Object)rootAndSelection[0], CompilationInfo.CacheClearPolicy.ON_CHANGE);
    }

    static BreadcrumbsElement[] rootAndSelection(CompilationInfo info, int caretPosition, AtomicBoolean cancel) {
        BreadCrumbsNodeImpl root = (BreadCrumbsNodeImpl)info.getCachedValue(BreadCrumbsScanningTask.class);
        if (root == null) {
            root = BreadCrumbsNodeImpl.createBreadcrumbs(null, info, new TreePath(info.getCompilationUnit()), false);
        }
        BreadCrumbsNodeImpl lastNode = root;
        boolean cont = true;
        block0: while (cont) {
            if (cancel.get()) {
                return null;
            }
            cont = false;
            List children = lastNode.getChildren();
            for (BreadcrumbsElement child : children) {
                if (cancel.get()) {
                    return null;
                }
                int[] pos = (int[])child.getLookup().lookup(int[].class);
                if (pos[0] > caretPosition || caretPosition > pos[1]) continue;
                lastNode = child;
                cont = true;
                continue block0;
            }
        }
        return new BreadcrumbsElement[]{root, lastNode};
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return BreadcrumbsController.BREADCRUMBS_SCHEDULER;
    }

    public void cancel() {
        this.cancel.set(true);
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singleton(new BreadCrumbsScanningTask());
        }
    }
}

