/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.preferences.base;

import org.jfree.report.modules.preferences.base.ConfigStorage;
import org.jfree.report.modules.preferences.base.NullConfigStorage;

public final class ConfigFactory {
    public static final String CONFIG_TARGET_KEY = "org.jfree.report.ConfigStore";
    private static ConfigFactory factory;
    private ConfigStorage userStorage;
    private ConfigStorage systemStorage;

    public static synchronized ConfigFactory getInstance() {
        if (factory == null) {
            factory = new ConfigFactory();
            factory.defineSystemStorage(new NullConfigStorage());
            factory.defineUserStorage(new NullConfigStorage());
        }
        return factory;
    }

    private ConfigFactory() {
    }

    public void defineUserStorage(ConfigStorage configStorage) {
        if (configStorage == null) {
            throw new NullPointerException();
        }
        this.userStorage = configStorage;
    }

    public void defineSystemStorage(ConfigStorage configStorage) {
        if (configStorage == null) {
            throw new NullPointerException();
        }
        this.systemStorage = configStorage;
    }

    public ConfigStorage getUserStorage() {
        return this.userStorage;
    }

    public ConfigStorage getSystemStorage() {
        return this.systemStorage;
    }

    public static boolean isValidPath(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isJavaIdentifierPart(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static String encodePath(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '$') {
                stringBuffer.append('$');
                stringBuffer.append('$');
                continue;
            }
            if (!Character.isJavaIdentifierPart(cArray[i])) {
                stringBuffer.append('$');
                String string2 = Integer.toHexString(cArray[i]);
                for (int j = string2.length(); j < 4; ++j) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }
}

